/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenOverwritingIdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@PageCacheExtension
@Neo4jLayoutExtension
public class StoreUpgraderTest {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fileSystem;
    private DatabaseLayout databaseLayout;
    private JobScheduler jobScheduler;
    private final Config allowMigrateConfig = Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true);
    private File prepareDatabaseDirectory;

    private static Collection<Arguments> versions() {
        return Collections.singletonList(Arguments.arguments((Object[])new Object[]{StandardV3_4.RECORD_FORMATS}));
    }

    @BeforeEach
    void prepareDb() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    private void init(RecordFormats formats) throws IOException {
        String version = formats.storeVersion();
        this.databaseLayout = this.neo4jLayout.databaseLayout("db-" + version);
        this.prepareDatabaseDirectory = this.testDirectory.directory("prepare_" + version, new String[0]);
        this.prepareSampleDatabase(version, this.fileSystem, this.databaseLayout, this.prepareDatabaseDirectory);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void forbidRegistrationOfParticipantsWithSameName(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader upgrader = this.newUpgrader(check, this.allowMigrateConfig, this.pageCache);
        upgrader.addParticipant((StoreMigrationParticipant)new EmptyNamedMigrationParticipant("foo"));
        Assertions.assertThrows(IllegalStateException.class, () -> upgrader.addParticipant((StoreMigrationParticipant)new EmptyNamedMigrationParticipant("foo")));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldHaltUpgradeIfUpgradeConfigurationVetoesTheProcess(RecordFormats formats) throws IOException {
        this.init(formats);
        Config deniedMigrationConfig = Config.newBuilder().set(GraphDatabaseSettings.allow_upgrade, (Object)false).set(GraphDatabaseSettings.record_format, (Object)"standard").build();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> this.newUpgrader(check, deniedMigrationConfig, this.pageCache).migrateIfNeeded(this.databaseLayout));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldRefuseToUpgradeIfAnyOfTheStoresWereNotShutDownCleanly(RecordFormats formats) throws IOException {
        this.init(formats);
        File comparisonDirectory = this.testDirectory.directory("shouldRefuseToUpgradeIfAnyOfTheStoresWereNotShutDownCleanly-comparison", new String[0]);
        StoreUpgraderTest.removeCheckPointFromTxLog(this.fileSystem, this.databaseLayout.databaseDirectory());
        this.fileSystem.deleteRecursively(comparisonDirectory);
        this.fileSystem.copyRecursively(this.databaseLayout.databaseDirectory(), comparisonDirectory);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> this.newUpgrader(check, this.pageCache).migrateIfNeeded(this.databaseLayout));
        MigrationTestUtils.verifyFilesHaveSameContent((FileSystemAbstraction)this.fileSystem, (File)comparisonDirectory, (File)this.databaseLayout.databaseDirectory());
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldRefuseToUpgradeIfAllOfTheStoresWereNotShutDownCleanly(RecordFormats formats) throws IOException {
        this.init(formats);
        File comparisonDirectory = this.testDirectory.directory("shouldRefuseToUpgradeIfAllOfTheStoresWereNotShutDownCleanly-comparison", new String[0]);
        StoreUpgraderTest.removeCheckPointFromTxLog(this.fileSystem, this.databaseLayout.databaseDirectory());
        this.fileSystem.deleteRecursively(comparisonDirectory);
        this.fileSystem.copyRecursively(this.databaseLayout.databaseDirectory(), comparisonDirectory);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> this.newUpgrader(check, this.pageCache).migrateIfNeeded(this.databaseLayout));
        MigrationTestUtils.verifyFilesHaveSameContent((FileSystemAbstraction)this.fileSystem, (File)comparisonDirectory, (File)this.databaseLayout.databaseDirectory());
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldContinueMovingFilesIfUpgradeCancelledWhileMoving(RecordFormats formats) throws Exception {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        String versionToMigrateTo = check.configuredVersion();
        StoreVersionCheck.Result upgradeResult = check.checkUpgrade(check.configuredVersion());
        Assertions.assertTrue((boolean)upgradeResult.outcome.isSuccessful());
        String versionToMigrateFrom = upgradeResult.actualVersion;
        StoreUpgrader upgrader = this.newUpgrader(check, this.allowMigrateConfig, this.pageCache);
        String failureMessage = "Just failing";
        upgrader.addParticipant(StoreUpgraderTest.participantThatWillFailWhenMoving(failureMessage));
        StoreUpgrader.UnableToUpgradeException e = (StoreUpgrader.UnableToUpgradeException)Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> upgrader.migrateIfNeeded(this.databaseLayout));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IOException));
        Assertions.assertEquals((Object)failureMessage, (Object)e.getCause().getMessage());
        upgrader = this.newUpgrader(check, this.pageCache);
        StoreMigrationParticipant observingParticipant = (StoreMigrationParticipant)Mockito.mock(StoreMigrationParticipant.class);
        upgrader.addParticipant(observingParticipant);
        upgrader.migrateIfNeeded(this.databaseLayout);
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant, (VerificationMode)Mockito.never())).migrate((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (ProgressReporter)ArgumentMatchers.any(ProgressReporter.class), (String)ArgumentMatchers.eq((Object)versionToMigrateFrom), (String)ArgumentMatchers.eq((Object)versionToMigrateTo));
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant)).moveMigratedFiles((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (String)ArgumentMatchers.eq((Object)versionToMigrateFrom), (String)ArgumentMatchers.eq((Object)versionToMigrateTo));
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant)).cleanup((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradedNeoStoreShouldHaveNewUpgradeTimeAndUpgradeId(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        this.newUpgrader(check, this.allowMigrateConfig, this.pageCache).migrateIfNeeded(this.databaseLayout);
        StoreFactory factory = new StoreFactory(this.databaseLayout, this.allowMigrateConfig, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem), this.pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MatcherAssert.assertThat((Object)neoStores.getMetaDataStore().getUpgradeTransaction(), (Matcher)Matchers.equalTo((Object)neoStores.getMetaDataStore().getLastCommittedTransaction()));
            MatcherAssert.assertThat((Object)neoStores.getMetaDataStore().getUpgradeTime(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)Long.MIN_VALUE)));
            long minuteAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(1L);
            MatcherAssert.assertThat((Object)neoStores.getMetaDataStore().getUpgradeTime(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(minuteAgo)));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeShouldNotLeaveLeftoverAndMigrationDirs(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        this.newUpgrader(check, this.allowMigrateConfig, this.pageCache).migrateIfNeeded(this.databaseLayout);
        MatcherAssert.assertThat(this.migrationHelperDirs(), (Matcher)Matchers.is((Matcher)Matchers.emptyCollectionOf(File.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeShouldGiveProgressMonitorProgressMessages(RecordFormats formats) throws Exception {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.newUpgrader(check, this.pageCache, this.allowMigrateConfig, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(this.databaseLayout);
        AssertableLogProvider.MessageMatcher messageMatcher = logProvider.rawMessageMatcher();
        messageMatcher.assertContains("Store files");
        messageMatcher.assertContains("Indexes");
        messageMatcher.assertContains("Successfully finished");
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgraderShouldCleanupLegacyLeftoverAndMigrationDirs(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_1"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_2"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_42"));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader storeUpgrader = this.newUpgrader(check, this.pageCache);
        storeUpgrader.migrateIfNeeded(this.databaseLayout);
        MatcherAssert.assertThat(this.migrationHelperDirs(), (Matcher)Matchers.is((Matcher)Matchers.emptyCollectionOf(File.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeFailsIfMigrationIsNotAllowed(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> this.newUpgrader(check, this.pageCache, Config.defaults(), (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(this.databaseLayout));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeMoveTransactionLogs(RecordFormats formats) throws IOException {
        this.init(formats);
        File txRoot = this.testDirectory.directory("customTxRoot", new String[0]);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Config config = Config.newBuilder().fromConfig(this.allowMigrateConfig).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txRoot.toPath().toAbsolutePath()).set(GraphDatabaseSettings.default_database, (Object)this.databaseLayout.getDatabaseName()).build();
        DatabaseLayout migrationLayout = DatabaseLayout.of((Config)config);
        this.newUpgrader(check, this.pageCache, config, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(migrationLayout);
        logProvider.rawMessageMatcher().assertContains("Starting transaction logs migration.");
        logProvider.rawMessageMatcher().assertContains("Transaction logs migration completed.");
        MatcherAssert.assertThat((Object)this.getLogFiles(migrationLayout.databaseDirectory()), (Matcher)Matchers.emptyArray());
        File databaseTransactionLogsHome = new File(txRoot, migrationLayout.getDatabaseName());
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(databaseTransactionLogsHome));
        Set<String> logFileNames = this.getLogFileNames(databaseTransactionLogsHome);
        MatcherAssert.assertThat(logFileNames, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assertions.assertEquals(this.getLogFileNames(this.prepareDatabaseDirectory), logFileNames);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void failToMoveTransactionLogsIfTheyAlreadyExist(RecordFormats formats) throws IOException {
        this.init(formats);
        File txRoot = this.testDirectory.directory("customTxRoot", new String[0]);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Config config = Config.newBuilder().fromConfig(this.allowMigrateConfig).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txRoot.toPath().toAbsolutePath()).set(GraphDatabaseSettings.default_database, (Object)this.databaseLayout.getDatabaseName()).build();
        DatabaseLayout migrationLayout = DatabaseLayout.of((Config)config);
        File databaseTransactionLogsHome = new File(txRoot, migrationLayout.getDatabaseName());
        Assertions.assertTrue((boolean)this.fileSystem.mkdir(databaseTransactionLogsHome));
        this.createDummyTxLogFiles(databaseTransactionLogsHome);
        Assertions.assertThrows(StoreUpgrader.TransactionLogsRelocationException.class, () -> this.newUpgrader(check, this.pageCache, config, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(migrationLayout));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void notParticipatingParticipantsAreNotPartOfMigration(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader storeUpgrader = this.newUpgrader(check, this.pageCache);
        MatcherAssert.assertThat((Object)storeUpgrader.getParticipants(), (Matcher)Matchers.hasSize((int)2));
    }

    private void createDummyTxLogFiles(File databaseTransactionLogsHome) throws IOException {
        Set<String> preparedLogFiles = this.getLogFileNames(this.prepareDatabaseDirectory);
        MatcherAssert.assertThat(preparedLogFiles, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        for (String preparedLogFile : preparedLogFiles) {
            this.fileSystem.write(new File(databaseTransactionLogsHome, preparedLogFile)).close();
        }
    }

    private File[] getLogFiles(File directory) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((File)directory, (FileSystemAbstraction)this.fileSystem).build().logFiles();
    }

    private Set<String> getLogFileNames(File directory) throws IOException {
        return Arrays.stream(LogFilesBuilder.logFilesBasedOnlyBuilder((File)directory, (FileSystemAbstraction)this.fileSystem).build().logFiles()).map(File::getName).collect(Collectors.toSet());
    }

    protected void prepareSampleDatabase(String version, FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, File databaseDirectory) throws IOException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)fileSystem, (File)databaseLayout.databaseDirectory(), (File)databaseDirectory);
    }

    private StoreVersionCheck getVersionCheck(PageCache pageCache) {
        return new RecordStoreVersionCheck(this.fileSystem, pageCache, this.databaseLayout, (LogProvider)NullLogProvider.getInstance(), this.getTuningConfig());
    }

    private static StoreMigrationParticipant participantThatWillFailWhenMoving(final String failureMessage) {
        return new AbstractStoreMigrationParticipant("Failing"){

            public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo) {
            }

            public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
                throw new IOException(failureMessage);
            }

            public void cleanup(DatabaseLayout migrationLayout) {
            }
        };
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, Config config, PageCache pageCache) throws IOException {
        return this.newUpgrader(storeVersionCheck, pageCache, config);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache) throws IOException {
        return this.newUpgrader(storeVersionCheck, pageCache, this.allowMigrateConfig);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache, Config config) throws IOException {
        return this.newUpgrader(storeVersionCheck, pageCache, config, MigrationProgressMonitor.SILENT);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache, Config config, MigrationProgressMonitor progressMonitor) throws IOException {
        NullLogService instance = NullLogService.getInstance();
        RecordStorageMigrator defaultMigrator = new RecordStorageMigrator(this.fileSystem, pageCache, this.getTuningConfig(), (LogService)instance, this.jobScheduler);
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator("Indexes", this.fileSystem, IndexProvider.EMPTY.directoryStructure(), storageEngineFactory);
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseLayout.databaseDirectory(), (FileSystemAbstraction)this.fileSystem).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader()).build();
        LogTailScanner logTailScanner = new LogTailScanner(logFiles, (LogEntryReader)new VersionAwareLogEntryReader(), new Monitors());
        StoreUpgrader upgrader = new StoreUpgrader(storeVersionCheck, progressMonitor, config, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), logTailScanner, new LegacyTransactionLogsLocator(config, this.databaseLayout));
        upgrader.addParticipant((StoreMigrationParticipant)indexMigrator);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant((StoreMigrationParticipant)defaultMigrator);
        return upgrader;
    }

    private List<File> migrationHelperDirs() {
        File[] tmpDirs = this.databaseLayout.listDatabaseFiles(file -> file.isDirectory() && (file.getName().equals("upgrade") || file.getName().startsWith("upgrade_backup")));
        Assertions.assertNotNull((Object)tmpDirs, (String)"Some IO errors occurred");
        return Arrays.asList(tmpDirs);
    }

    private Config getTuningConfig() {
        return Config.defaults((Setting)GraphDatabaseSettings.record_format, (Object)this.getRecordFormatsName());
    }

    protected String getRecordFormatsName() {
        return "standard";
    }

    public static void removeCheckPointFromTxLog(FileSystemAbstraction fileSystem, File databaseDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)databaseDirectory, (FileSystemAbstraction)fileSystem).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)new VersionAwareLogEntryReader(), new Monitors());
        LogTailScanner.LogTailInformation logTailInformation = tailScanner.getTailInformation();
        if (logTailInformation.commitsAfterLastCheckpoint()) {
            return;
        }
        Assertions.assertNotNull((Object)logTailInformation.lastCheckPoint);
        LogPosition logPosition = logTailInformation.lastCheckPoint.getLogPosition();
        File logFile = logFiles.getLogFileForVersion(logPosition.getLogVersion());
        long byteOffset = logPosition.getByteOffset();
        fileSystem.truncate(logFile, byteOffset);
    }

    private static class EmptyNamedMigrationParticipant
    extends AbstractStoreMigrationParticipant {
        protected EmptyNamedMigrationParticipant(String name) {
            super(name);
        }

        public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo) {
        }

        public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToMigrateFrom, String versionToMigrateTo) {
        }

        public void cleanup(DatabaseLayout migrationLayout) {
        }
    }
}

