/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class TransactionLogsInSeparateLocationIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;

    TransactionLogsInSeparateLocationIT() {
    }

    @Test
    void databaseWithTransactionLogsInSeparateAbsoluteLocation() throws IOException {
        File txDirectory = this.testDirectory.directory("transaction-logs", new String[0]);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txDirectory.toPath().toAbsolutePath()).build();
        DatabaseLayout layout = DatabaseLayout.of((Config)config);
        TransactionLogsInSeparateLocationIT.performTransactions(txDirectory.toPath().toAbsolutePath(), layout.databaseDirectory());
        this.verifyTransactionLogs(layout.getTransactionLogsDirectory(), layout.databaseDirectory());
    }

    private static void performTransactions(Path txPath, File storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)txPath).build();
        GraphDatabaseService database = managementService.database("neo4j");
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)"b");
                node.setProperty("c", (Object)"d");
                transaction.commit();
                continue;
            }
        }
        managementService.shutdown();
    }

    private void verifyTransactionLogs(File txDirectory, File storeDir) throws IOException {
        LogFiles storeDirLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)storeDir, (FileSystemAbstraction)this.fileSystem).build();
        Assertions.assertFalse((boolean)storeDirLogs.versionExists(0L));
        LogFiles txDirectoryLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)txDirectory, (FileSystemAbstraction)this.fileSystem).build();
        Assertions.assertTrue((boolean)txDirectoryLogs.versionExists(0L));
        try (PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel = txDirectoryLogs.openForVersion(0L);){
            MatcherAssert.assertThat((Object)physicalLogVersionedStoreChannel.size(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        }
    }
}

