/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;

class RelationshipSelectionTestBase {
    final int typeA = 100;
    final int typeB = 101;
    final int typeC = 102;

    RelationshipSelectionTestBase() {
    }

    void assertOutgoing(ResourceIterator<R> iterator, int targetNode, int type) {
        Assertions.assertTrue((boolean)iterator.hasNext(), (String)"has next");
        R r = (R)iterator.next();
        Assertions.assertEquals((int)type, (int)r.type, (String)"expected type");
        Assertions.assertEquals((long)targetNode, (long)r.targetNode, (String)"expected target");
    }

    void assertIncoming(ResourceIterator<R> iterator, int sourceNode, int type) {
        Assertions.assertTrue((boolean)iterator.hasNext(), (String)"has next");
        R r = (R)iterator.next();
        Assertions.assertEquals((int)type, (int)r.type, (String)"expected type");
        Assertions.assertEquals((long)sourceNode, (long)r.sourceNode, (String)"expected source");
    }

    void assertLoop(ResourceIterator<R> iterator, int type) {
        Assertions.assertTrue((boolean)iterator.hasNext(), (String)"has next");
        R r = (R)iterator.next();
        Assertions.assertEquals((int)type, (int)r.type, (String)"expected type");
        Assertions.assertEquals((long)r.sourceNode, (long)r.targetNode, (String)"expected loop");
    }

    void assertEmpty(ResourceIterator<R> iterator) {
        Assertions.assertFalse((boolean)iterator.hasNext(), (String)"no more");
    }

    void assertOutgoing(RelationshipSelectionCursor cursor, int targetNode, int type) {
        Assertions.assertTrue((boolean)cursor.next(), (String)"has next");
        Assertions.assertEquals((int)type, (int)cursor.type(), (String)"expected type");
        Assertions.assertEquals((long)targetNode, (long)cursor.targetNodeReference(), (String)"expected target");
    }

    void assertIncoming(RelationshipSelectionCursor cursor, int sourceNode, int type) {
        Assertions.assertTrue((boolean)cursor.next(), (String)"has next");
        Assertions.assertEquals((int)type, (int)cursor.type(), (String)"expected type");
        Assertions.assertEquals((long)sourceNode, (long)cursor.sourceNodeReference(), (String)"expected source");
    }

    void assertLoop(RelationshipSelectionCursor cursor, int type) {
        Assertions.assertTrue((boolean)cursor.next(), (String)"has next");
        Assertions.assertEquals((int)type, (int)cursor.type(), (String)"expected type");
        Assertions.assertEquals((long)cursor.sourceNodeReference(), (long)cursor.targetNodeReference(), (String)"expected loop");
    }

    void assertEmpty(RelationshipSelectionCursor cursor) {
        Assertions.assertFalse((boolean)cursor.next(), (String)"no more");
    }

    int[] types(int ... types) {
        return types;
    }

    static class R {
        final long relationship;
        final long sourceNode;
        final int type;
        final long targetNode;

        R(long relationship, long sourceNode, int type, long targetNode) {
            this.relationship = relationship;
            this.sourceNode = sourceNode;
            this.type = type;
            this.targetNode = targetNode;
        }
    }
}

