/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class SchemaLoggingIT {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Inject
    private GraphDatabaseAPI db;

    SchemaLoggingIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setInternalLogProvider((LogProvider)this.logProvider);
    }

    @Test
    void shouldLogUserReadableLabelAndPropertyNames() throws Exception {
        String labelName = "User";
        String property = "name";
        SchemaLoggingIT.createIndex(this.db, labelName, property);
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        IndexProviderMap indexProviderMap = (IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class);
        IndexProvider defaultProvider = indexProviderMap.getDefaultProvider();
        IndexProviderDescriptor providerDescriptor = defaultProvider.getProviderDescriptor();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.info(Matchers.containsString((String)"Index population started: [%s]"), new Object[]{":User(name) [provider: {key=" + providerDescriptor.getKey() + ", version=" + providerDescriptor.getVersion() + "}]"})});
        Assert.assertEventually(() -> null, (Matcher)new LogMessageMatcher(match, providerDescriptor), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static void createIndex(GraphDatabaseAPI db, String labelName, String property) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)labelName)).on(property).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private class LogMessageMatcher
    extends BaseMatcher<Object> {
        private static final String CREATION_FINISHED = "Index creation finished. Index [%s] is %s.";
        private final AssertableLogProvider.LogMatcherBuilder match;
        private final IndexProviderDescriptor descriptor;

        LogMessageMatcher(AssertableLogProvider.LogMatcherBuilder match, IndexProviderDescriptor descriptor) {
            this.match = match;
            this.descriptor = descriptor;
        }

        public boolean matches(Object item) {
            return SchemaLoggingIT.this.logProvider.containsMatchingLogCall(this.match.info(Matchers.containsString((String)CREATION_FINISHED), new Object[]{":User(name) [provider: {key=" + this.descriptor.getKey() + ", version=" + this.descriptor.getVersion() + "}]", "ONLINE"}));
        }

        public void describeTo(Description description) {
            description.appendText(" expected log message containing: '").appendText(CREATION_FINISHED).appendText("', but not found. Messages was: '").appendText(SchemaLoggingIT.this.logProvider.serialize()).appendText(".");
        }
    }
}

