/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.integrationtest.ProcedureITBase;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Values;

abstract class CommunityProcedureITBase
extends KernelIntegrationTest
implements ProcedureITBase {
    CommunityProcedureITBase() {
    }

    @Test
    void listProcedures() throws Throwable {
        ProcedureHandle procedures = this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "procedures"}));
        RawIterator stream = this.procs().procedureCallRead(procedures.id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        List actual = Iterators.asList((RawIterator)stream);
        List<Object[]> expected = this.getExpectedCommunityProcs();
        Map resultMap = actual.stream().collect(Collectors.toMap(row -> ((StringValue)row[0]).stringValue(), Function.identity()));
        Map expectedMap = expected.stream().collect(Collectors.toMap(row -> ((StringValue)row[0]).stringValue(), Function.identity()));
        MatcherAssert.assertThat(resultMap.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedMap.keySet().toArray()));
        for (String procName : resultMap.keySet()) {
            AnyValue[] actualArray = (AnyValue[])resultMap.get(procName);
            Object[] expectedArray = (Object[])expectedMap.get(procName);
            Assertions.assertNotNull((Object)expectedArray, (String)("Got an unexpected entry for " + procName + " =>\n" + this.printElementsOfArray(actualArray)));
            Assertions.assertEquals((int)expectedArray.length, (int)actualArray.length, (String)("Count of columns for " + procName + " does not match"));
            for (int i = 1; i < actualArray.length; ++i) {
                Matcher matcher = expectedArray[i] instanceof TextArray ? IsEqual.equalTo((Object)Values.NO_VALUE) : (expectedArray[i] instanceof Matcher ? (Matcher)expectedArray[i] : IsEqual.equalTo((Object)expectedArray[i]));
                MatcherAssert.assertThat((String)("Column " + i + " for " + procName + " does not match"), (Object)actualArray[i], (Matcher)matcher);
            }
        }
        this.commit();
    }

    private String printElementsOfArray(AnyValue[] array) {
        StringBuilder result = new StringBuilder();
        for (AnyValue anyValue : array) {
            result.append(anyValue).append("\n");
        }
        return result.toString();
    }
}

