/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class DeepRelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long three_root;
    private static int expected_total;
    private static int expected_unique;
    private RelationshipType PARENT = RelationshipType.withName((String)"PARENT");

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            Node inter;
            int i;
            Node root = tx.createNode();
            three_root = root.getId();
            Node[] leafs = new Node[32];
            for (int i2 = 0; i2 < leafs.length; ++i2) {
                leafs[i2] = tx.createNode();
            }
            int offset = 0;
            int duplicate = 12;
            Node interdup = tx.createNode();
            interdup.createRelationshipTo(root, this.PARENT);
            offset = this.relate(duplicate, leafs, offset, interdup);
            for (i = 0; i < 5; ++i) {
                inter = tx.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(3 + i, leafs, offset, inter);
            }
            interdup.createRelationshipTo(root, this.PARENT);
            for (i = 0; i < 4; ++i) {
                inter = tx.createNode();
                inter.createRelationshipTo(root, this.PARENT);
                offset = this.relate(2 + i, leafs, offset, inter);
            }
            Node inter2 = tx.createNode();
            inter2.createRelationshipTo(root, this.PARENT);
            offset = this.relate(1, leafs, offset, inter2);
            expected_total = offset + duplicate;
            expected_unique = leafs.length;
            tx.commit();
        }
    }

    private int relate(int count, Node[] selection, int offset, Node parent) {
        for (int i = 0; i < count; ++i) {
            selection[offset++ % selection.length].createRelationshipTo(parent, this.PARENT);
        }
        return offset;
    }

    @Test
    void shouldTraverseTreeOfDepthThree() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship1 = this.cursors.allocateRelationshipTraversalCursor();
             RelationshipTraversalCursor relationship2 = this.cursors.allocateRelationshipTraversalCursor();){
            LongHashSet leafs = new LongHashSet();
            long total = 0L;
            this.read.singleNode(three_root, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access root node");
            node.relationships(group);
            Assertions.assertFalse((boolean)node.next(), (String)"single root");
            Assertions.assertTrue((boolean)group.next(), (String)"access group of root");
            group.incoming(relationship1);
            Assertions.assertFalse((boolean)group.next(), (String)"single group of root");
            while (relationship1.next()) {
                relationship1.neighbour(node);
                Assertions.assertTrue((boolean)node.next(), (String)"child level 1");
                node.relationships(group);
                Assertions.assertFalse((boolean)node.next(), (String)"single node");
                Assertions.assertTrue((boolean)group.next(), (String)"group of level 1 child");
                group.incoming(relationship2);
                Assertions.assertFalse((boolean)group.next(), (String)"single group of level 1 child");
                while (relationship2.next()) {
                    leafs.add(relationship2.neighbourNodeReference());
                    ++total;
                }
            }
            Assertions.assertEquals((long)expected_total, (long)total, (String)"total number of leaf nodes");
            Assertions.assertEquals((int)expected_unique, (int)leafs.size(), (String)"number of distinct leaf nodes");
        }
    }
}

