/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;

public abstract class ParallelRelationshipCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList RELATIONSHIPS;
    private static final int NUMBER_OF_RELATIONSHIPS = 128;
    private static final ToLongFunction<RelationshipScanCursor> REL_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R")).getId());
            }
            RELATIONSHIPS = list;
            tx.commit();
        }
    }

    @Test
    void shouldScanASubsetOfRelationships() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)relationships, 3));
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(0), (long)relationships.relationshipReference());
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(1), (long)relationships.relationshipReference());
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(2), (long)relationships.relationshipReference());
            Assertions.assertFalse((boolean)relationships.next());
        }
    }

    @Test
    void shouldHandleSizeHintOverflow() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)relationships, 256));
            LongArrayList ids = new LongArrayList();
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
        }
    }

    @Test
    void shouldFailForSizeHintZero() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertThrows(IllegalArgumentException.class, () -> scan.reserveBatch((Cursor)relationships, 0));
        }
    }

    @Test
    void shouldScanAllRelationshipsInBatches() {
        LongArrayList ids = new LongArrayList();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            Scan scan = this.read.allRelationshipsScan();
            while (scan.reserveBatch((Cursor)relationships, 3)) {
                while (relationships.next()) {
                    ids.add(relationships.relationshipReference());
                }
            }
        }
        Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreads() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, () -> ((CursorFactory)cursors).allocateRelationshipScanCursor(), REL_GET, 32));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, () -> ((CursorFactory)cursors).allocateRelationshipScanCursor(), REL_GET, 32));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, () -> ((CursorFactory)cursors).allocateRelationshipScanCursor(), REL_GET, 32));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, () -> ((CursorFactory)cursors).allocateRelationshipScanCursor(), REL_GET, 32));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            MutableLongList concat = TestUtils.concat(ids1, ids2, ids3, ids4).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            Supplier<RelationshipScanCursor> allocateRelCursor = () -> ((CursorFactory)cursors).allocateRelationshipScanCursor();
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, allocateRelCursor, REL_GET, 100));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, allocateRelCursor, REL_GET, 100));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, allocateRelCursor, REL_GET, 100));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, allocateRelCursor, REL_GET, 100));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            MutableLongList concat = TestUtils.concat(ids1, ids2, ids3, ids4).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromRandomlySizedWorkers() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>();
            for (int i = 0; i < 11; ++i) {
                futures.add(service.submit(TestUtils.randomBatchWorker(scan, () -> ((CursorFactory)cursors).allocateRelationshipScanCursor(), REL_GET)));
            }
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
            List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    static {
        REL_GET = RelationshipDataAccessor::relationshipReference;
    }
}

