/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
public class CustomBlockSizeStoreTest {
    @Inject
    private GraphDatabaseAPI databaseAPI;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.string_block_size, (Object)62);
        builder.setConfig(GraphDatabaseSettings.array_block_size, (Object)302);
    }

    @Test
    public void testSetBlockSize() {
        NeoStores neoStores = ((RecordStorageEngine)this.databaseAPI.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        Assertions.assertEquals((int)70, (int)propertyStore.getStringStore().getRecordSize());
        Assertions.assertEquals((int)310, (int)propertyStore.getArrayStore().getRecordSize());
    }
}

