/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ReadTransactionLogWritingTest {
    @Inject
    private GraphDatabaseAPI db;
    private final Label label = Label.label((String)"Test");
    private Node node;
    private Relationship relationship;
    private long logEntriesWrittenBeforeReadOperations;

    ReadTransactionLogWritingTest() {
    }

    @BeforeEach
    void createDataset() {
        try (Transaction tx = this.db.beginTx();){
            this.node = tx.createNode(new Label[]{this.label});
            this.node.setProperty("short", (Object)123);
            this.node.setProperty("long", (Object)this.longString(300));
            this.relationship = this.node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            this.relationship.setProperty("short", (Object)123);
            this.relationship.setProperty("long", (Object)this.longString(300));
            tx.commit();
        }
        this.logEntriesWrittenBeforeReadOperations = this.countLogEntries();
    }

    @Test
    void shouldNotWriteAnyLogCommandInPureReadTransaction() {
        this.executeTransaction(this.getRelationships());
        this.executeTransaction(this.getProperties());
        this.executeTransaction(this.getById());
        this.executeTransaction(this.getNodesFromRelationship());
        long actualCount = this.countLogEntries();
        Assertions.assertEquals((long)this.logEntriesWrittenBeforeReadOperations, (long)actualCount, (String)("There were " + (actualCount - this.logEntriesWrittenBeforeReadOperations) + " log entries written during one or more pure read transactions"));
    }

    private long countLogEntries() {
        FileSystemAbstraction fs = (FileSystemAbstraction)this.db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
        LogFiles logFiles = (LogFiles)this.db.getDependencyResolver().resolveDependency(LogFiles.class);
        try {
            LogTestUtils.CountingLogHook logicalLogCounter = new LogTestUtils.CountingLogHook();
            LogTestUtils.filterNeostoreLogicalLog((LogFiles)logFiles, (FileSystemAbstraction)fs, (LogTestUtils.LogHook)logicalLogCounter);
            long txLogRecordCount = logFiles.getLogFileInformation().getLastEntryId();
            return (long)logicalLogCounter.getCount() + txLogRecordCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String longString(int length) {
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = (char)(97 + i % 10);
        }
        return new String(characters);
    }

    private void executeTransaction(Consumer<Transaction> consumer) {
        this.executeTransaction(consumer, true);
        this.executeTransaction(consumer, false);
    }

    private void executeTransaction(Consumer<Transaction> consumer, boolean success) {
        try (Transaction tx = this.db.beginTx();){
            consumer.accept(tx);
            if (success) {
                tx.commit();
            }
        }
    }

    private Consumer<Transaction> getRelationships() {
        return tx -> Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)tx.getNodeById(this.node.getId()).getRelationships()));
    }

    private Consumer<Transaction> getNodesFromRelationship() {
        return tx -> {
            Relationship rel = tx.getRelationshipById(this.relationship.getId());
            rel.getEndNode();
            rel.getStartNode();
            rel.getNodes();
            rel.getOtherNode(this.node);
        };
    }

    private Consumer<Transaction> getById() {
        return tx -> {
            tx.getNodeById(this.node.getId());
            tx.getRelationshipById(this.relationship.getId());
        };
    }

    private Consumer<Transaction> getProperties() {
        return new Consumer<Transaction>(){

            @Override
            public void accept(Transaction tx) {
                this.getAllProperties((Entity)tx.getNodeById(ReadTransactionLogWritingTest.this.node.getId()));
                this.getAllProperties((Entity)tx.getRelationshipById(ReadTransactionLogWritingTest.this.relationship.getId()));
            }

            private void getAllProperties(Entity entity) {
                for (String key : entity.getPropertyKeys()) {
                    entity.getProperty(key);
                }
            }
        };
    }
}

