/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;

@EphemeralNeo4jLayoutExtension
class CheckPointerIntegrationTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementServiceBuilder builder;

    CheckPointerIntegrationTest() {
    }

    @BeforeEach
    void setup() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent();
    }

    @Test
    void databaseShutdownDuringConstantCheckPointing() throws InterruptedException {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        Thread.sleep(10L);
        managementService.shutdown();
    }

    @Test
    void shouldCheckPointBasedOnTime() throws Throwable {
        long millis = 200L;
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(millis)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (CheckPointerIntegrationTest.checkPointInTxLog(db) == 0) {
            Thread.sleep(millis);
            Assertions.assertTrue((System.currentTimeMillis() < endTime ? 1 : 0) != 0, (String)"Took too long to produce a checkpoint");
        }
        managementService.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(this.logsDirectory(), (FileSystemAbstraction)this.fs).find(0L);
        Assertions.assertTrue((checkPoints.size() >= 2 ? 1 : 0) != 0, (String)("Expected at least two (at least one for time interval and one for shutdown), was " + checkPoints.toString()));
    }

    private static int checkPointInTxLog(GraphDatabaseService db) throws IOException {
        LogFiles logFiles = (LogFiles)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        try (ReadableLogChannel reader = logFile.getReader(logFiles.extractHeader(0L).getStartPosition());){
            LogEntry entry;
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
            int counter = 0;
            while ((entry = logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader)) != null) {
                if (!(entry instanceof CheckPoint)) continue;
                ++counter;
            }
            int n = counter;
            return n;
        }
    }

    @Test
    void shouldCheckPointBasedOnTxCount() throws Throwable {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
        int counter = CheckPointerIntegrationTest.checkPointInTxLog(db);
        MatcherAssert.assertThat((Object)counter, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        managementService.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(this.logsDirectory(), (FileSystemAbstraction)this.fs).find(0L);
        Assertions.assertEquals((int)(counter + 1), (int)checkPoints.size());
    }

    @Test
    void shouldNotCheckPointWhenThereAreNoCommits() throws Throwable {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofSeconds(1L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
        MatcherAssert.assertThat((Object)CheckPointerIntegrationTest.checkPointInTxLog(db), (Matcher)Matchers.equalTo((Object)0));
        managementService.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(this.logsDirectory(), (FileSystemAbstraction)this.fs).find(0L);
        Assertions.assertEquals((int)1, (int)checkPoints.size());
    }

    @Test
    void shouldBeAbleToStartAndShutdownMultipleTimesTheDBWithoutCommittingTransactions() throws Throwable {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMinutes(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L));
        DatabaseManagementService managementService1 = databaseManagementServiceBuilder.build();
        managementService1.shutdown();
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        managementService.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(this.logsDirectory(), (FileSystemAbstraction)this.fs).find(0L);
        Assertions.assertEquals((int)2, (int)checkPoints.size());
    }

    private static void triggerCheckPointAttempt(GraphDatabaseService db) throws Exception {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    private File logsDirectory() {
        return this.databaseLayout.getTransactionLogsDirectory();
    }

    private static class CheckPointCollector {
        private final LogFiles logFiles;
        private final LogEntryReader logEntryReader = new VersionAwareLogEntryReader();

        CheckPointCollector(File directory, FileSystemAbstraction fileSystem) throws IOException {
            this.logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)directory, (FileSystemAbstraction)fileSystem).withLogEntryReader(this.logEntryReader).build();
        }

        public List<CheckPoint> find(long version) throws IOException {
            ArrayList<CheckPoint> checkPoints = new ArrayList<CheckPoint>();
            while (version >= 0L && this.logFiles.versionExists(version)) {
                PhysicalLogVersionedStoreChannel channel = this.logFiles.openForVersion(version);
                ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)channel);
                try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableClosablePositionAwareChecksumChannel)recoveredDataChannel);){
                    while (cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (!(entry instanceof CheckPoint)) continue;
                        checkPoints.add((CheckPoint)entry);
                    }
                }
                --version;
            }
            return checkPoints;
        }
    }
}

