/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.ImpermanentDbmsRule;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.rule.TestDirectory;

public class GraphDatabaseServiceTest {
    @ClassRule
    public static final DbmsRule globalDb = new ImpermanentDbmsRule().withSetting(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ofSeconds(10L));
    private final ExpectedException exception = ExpectedException.none();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final OtherThreadRule<Void> t2 = new OtherThreadRule();
    private final OtherThreadRule<Void> t3 = new OtherThreadRule();
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.exception);
    private DatabaseManagementService managementService;

    @Before
    public void before() {
        this.t2.init("T2-" + this.getClass().getName());
        this.t3.init("T3-" + this.getClass().getName());
    }

    @After
    public void after() {
        this.t2.close();
        this.t3.close();
    }

    @Test
    public void givenShutdownDatabaseWhenBeginTxThenExceptionIsThrown() {
        GraphDatabaseService db = this.getTemporaryDatabase();
        this.managementService.shutdown();
        this.exception.expect(DatabaseShutdownException.class);
        db.beginTx();
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownThenWaitForTxToFinish() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        Barrier.Control barrier = new Barrier.Control();
        Future txFuture = this.t2.execute(state -> {
            try (Transaction tx = db.beginTx();){
                barrier.reached();
                tx.createNode();
                tx.commit();
            }
            return null;
        });
        barrier.await();
        Future shutdownFuture = this.t3.execute(state -> {
            this.managementService.shutdown();
            return null;
        });
        this.t3.get().waitUntilWaiting(location -> location.isAt(DatabaseAvailability.class, "stop"));
        barrier.release();
        try {
            txFuture.get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        shutdownFuture.get();
    }

    @Test
    public void terminateTransactionThrowsExceptionOnNextOperation() {
        DbmsRule db = globalDb;
        try (Transaction tx = db.beginTx();){
            tx.terminate();
            try {
                tx.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownAndStartNewTxThenBeginTxTimesOut() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        Barrier.Control barrier = new Barrier.Control();
        this.t2.execute(state -> {
            try (Transaction tx = db.beginTx();){
                barrier.reached();
            }
            return null;
        });
        barrier.await();
        Future shutdownFuture = this.t3.execute(state -> {
            this.managementService.shutdown();
            return null;
        });
        this.t3.get().waitUntilWaiting(location -> location.isAt(DatabaseAvailability.class, "stop"));
        barrier.release();
        shutdownFuture.get();
        try {
            db.beginTx();
            Assert.fail((String)"Should fail");
        }
        catch (DatabaseShutdownException databaseShutdownException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLetDetectedDeadlocksDuringCommitBeThrownInTheirOriginalForm() throws Exception {
        DbmsRule db = globalDb;
        Node n1 = this.createNode((GraphDatabaseService)db);
        Node n2 = this.createNode((GraphDatabaseService)db);
        Relationship r3 = this.createRelationship((GraphDatabaseService)db, n1);
        Relationship r2 = this.createRelationship((GraphDatabaseService)db, n1);
        Relationship r1 = this.createRelationship((GraphDatabaseService)db, n1);
        Transaction t1Tx = db.beginTx();
        Transaction t2Tx = (Transaction)this.t2.execute(this.beginTx((GraphDatabaseService)db)).get();
        t1Tx.getNodeById(n2.getId()).setProperty("locked", (Object)"indeed");
        this.t2.execute(this.setProperty((Entity)t2Tx.getRelationshipById(r1.getId()), "locked", "absolutely")).get();
        Future t2n2Wait = this.t2.execute(this.setProperty((Entity)t2Tx.getNodeById(n2.getId()), "locked", "In my dreams"));
        this.t2.get().waitUntilWaiting();
        t1Tx.getRelationshipById(r2.getId()).delete();
        try {
            t1Tx.commit();
            Assert.fail((String)"Should throw exception about deadlock");
        }
        catch (Exception e) {
            Assert.assertEquals(DeadlockDetectedException.class, e.getClass());
        }
        finally {
            t2n2Wait.get();
            this.t2.execute(this.close(t2Tx)).get();
        }
    }

    @Test
    public void terminationOfClosedTransactionDoesNotInfluenceNextTransaction() {
        Transaction transaction;
        DbmsRule db = globalDb;
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        try (Transaction tx = transaction = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        transaction.terminate();
        tx = db.beginTx();
        try {
            Assert.assertThat((Object)tx.getAllNodes(), (Matcher)Matchers.is((Matcher)Matchers.iterableWithSize((int)2)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Transaction> beginTx(GraphDatabaseService db) {
        return state -> db.beginTx();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> setProperty(Entity entity, String key, String value) {
        return state -> {
            entity.setProperty(key, (Object)value);
            return null;
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> close(Transaction tx) {
        return state -> {
            tx.close();
            return null;
        };
    }

    private Relationship createRelationship(GraphDatabaseService db, Node node) {
        try (Transaction tx = db.beginTx();){
            Relationship rel = tx.getNodeById(node.getId()).createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.commit();
            Relationship relationship = rel;
            return relationship;
        }
    }

    private Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private GraphDatabaseService getTemporaryDatabase() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.directory("impermanent", new String[0])).impermanent().setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ofSeconds(10L)).build();
        return this.managementService.database("neo4j");
    }
}

