/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PositionableChannel;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class VersionAwareLogEntryReaderIT {
    private static final long END_OF_DATA_OFFSET = 195L;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseManagementService managementService;
    private DatabaseLayout databaseLayout;
    private final VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();

    VersionAwareLogEntryReaderIT() {
    }

    @BeforeEach
    void setUp() {
        GraphDatabaseService database = this.managementService.database("neo4j");
        this.createNode(database);
        this.databaseLayout = ((GraphDatabaseAPI)database).databaseLayout();
        this.managementService.shutdown();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void readOnlyLogFilesWhileCommandsAreAvailable() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogEntryReader((LogEntryReader)this.entryReader).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            Assertions.assertEquals((long)ByteUnit.kibiBytes((long)128L), (long)logFiles.getHighestLogFile().length());
            LogPosition logPosition = this.entryReader.lastPosition();
            Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
            Assertions.assertEquals((long)195L, (long)logPosition.getByteOffset());
        }
    }

    @Test
    void correctlyResetPositionWhenEndOfCommandsReached() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogEntryReader((LogEntryReader)this.entryReader).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            LogPosition logPosition = this.entryReader.lastPosition();
            Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
            Assertions.assertEquals((long)195L, (long)logPosition.getByteOffset());
            for (int i = 0; i < 10; ++i) {
                Assertions.assertEquals((long)195L, (long)this.getLastReadablePosition(logFiles));
            }
        }
    }

    @Test
    void correctlyResetPositionOfObservedZeroWhenChannelSwitchOnExactlyCheckedByte() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogEntryReader((LogEntryReader)this.entryReader).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            LogPositionMarker positionMarker = new LogPositionMarker();
            LogFile logFile = logFiles.getLogFile();
            long initialPosition = this.getLastReadablePosition(logFiles);
            long checkpointsEndDataOffset = (long)ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE + initialPosition;
            FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
            TransactionLogWriter logWriter = new TransactionLogWriter(new LogEntryWriter((WritableChecksumChannel)writer));
            do {
                logWriter.checkPoint(new LogPosition(4L, 5L));
                writer.getCurrentPosition(positionMarker);
            } while (positionMarker.getByteOffset() <= checkpointsEndDataOffset);
            writer.prepareForFlush().flush();
            logFiles.getLogFile().rotate();
            this.fs.truncate(logFiles.getLogFileForVersion(0L), checkpointsEndDataOffset);
            try (StoreChannel storeChannel = this.fs.write(logFiles.getLogFileForVersion(1L));){
                storeChannel.position(64L);
                storeChannel.write(ByteBuffer.wrap(new byte[]{0}));
            }
            try (ReadableLogChannel logChannel = logFiles.getLogFile().getReader(new LogPosition(0L, initialPosition));){
                LogEntry logEntry = this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)logChannel);
                MatcherAssert.assertThat((Object)logEntry, (Matcher)CoreMatchers.instanceOf(CheckPoint.class));
                CheckPoint checkPoint = (CheckPoint)logEntry;
                LogPosition logPosition = checkPoint.getLogPosition();
                Assertions.assertEquals((long)4L, (long)logPosition.getLogVersion());
                Assertions.assertEquals((long)5L, (long)logPosition.getByteOffset());
                ((PositionableChannel)logChannel).setCurrentPosition(checkpointsEndDataOffset);
                while (this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)logChannel) != null) {
                }
                LogPosition position = this.entryReader.lastPosition();
                Assertions.assertEquals((long)64L, (long)position.getByteOffset());
                Assertions.assertEquals((long)1L, (long)position.getLogVersion());
            }
        }
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void readTillTheEndOfNotPreallocatedFile() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogEntryReader((LogEntryReader)this.entryReader).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            LogPosition logPosition = this.entryReader.lastPosition();
            Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
            Assertions.assertEquals((long)logFiles.getHighestLogFile().length(), (long)logPosition.getByteOffset());
        }
    }

    private long getLastReadablePosition(LogFiles logFiles) throws IOException {
        try (ReadableLogChannel logChannel = logFiles.getLogFile().getReader(logFiles.extractHeader(0L).getStartPosition());){
            while (this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)logChannel) != null) {
            }
            long l = this.entryReader.lastPosition().getByteOffset();
            return l;
        }
    }

    private void createNode(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
    }
}

