/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.logging.Logger;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class KernelDiagnosticsIT {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private Neo4jLayout neo4jLayout;

    KernelDiagnosticsIT() {
    }

    @Test
    void shouldIncludeNativeIndexFilesInTotalMappedSize() {
        boolean i = false;
        for (GraphDatabaseSettings.SchemaIndex schemaIndex : GraphDatabaseSettings.SchemaIndex.values()) {
            Neo4jLayout layout = this.neo4jLayout;
            KernelDiagnosticsIT.createIndexInIsolatedDbInstance(layout.homeDirectory(), schemaIndex);
            DatabaseLayout databaseLayout = layout.databaseLayout("neo4j");
            StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
            StoreFilesDiagnostics files = new StoreFilesDiagnostics(storageEngineFactory, this.fs, databaseLayout);
            SizeCapture capture = new SizeCapture();
            files.dump(capture::log);
            Assertions.assertNotNull((Object)capture.size);
            long expected = KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(databaseLayout.databaseDirectory());
            Assertions.assertEquals((Object)ByteUnit.bytesToString((long)expected), (Object)capture.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createIndexInIsolatedDbInstance(File homeDir, GraphDatabaseSettings.SchemaIndex index) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(homeDir).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)index.providerName()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            Label label = Label.label((String)("Label-" + index.providerName()));
            String key = "key";
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 100; ++i) {
                    tx.createNode(new Label[]{label}).setProperty(key, (Object)i);
                }
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().indexFor(label).on(key).create();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private static long manuallyCountTotalMappedFileSize(File dbDir) {
        MutableLong result = new MutableLong();
        NativeIndexFileFilter nativeIndexFilter = new NativeIndexFileFilter(dbDir);
        KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(dbDir, result, nativeIndexFilter);
        return result.getValue();
    }

    private static void manuallyCountTotalMappedFileSize(File dir, MutableLong result, NativeIndexFileFilter nativeIndexFilter) {
        Set storeFiles = Stream.of(StoreType.values()).map(type -> type.getDatabaseFile().getName()).collect(Collectors.toSet());
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(file, result, nativeIndexFilter);
                continue;
            }
            if (!storeFiles.contains(file.getName()) && !file.getName().equals(DatabaseFile.LABEL_SCAN_STORE.getName()) && !nativeIndexFilter.accept(file)) continue;
            result.add(file.length());
        }
    }

    private class SizeCapture
    implements Logger {
        private String size;

        private SizeCapture() {
        }

        public void log(@Nonnull String message) {
            if (message.contains("Total size of mapped files")) {
                int beginPos = message.lastIndexOf(": ");
                Assertions.assertTrue((beginPos != -1 ? 1 : 0) != 0);
                this.size = message.substring(beginPos + 2);
            }
        }

        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public void log(@Nonnull String format, Object ... arguments) {
            this.log(String.format(format, arguments));
        }

        public void bulk(@Nonnull Consumer<Logger> consumer) {
            throw new UnsupportedOperationException();
        }
    }
}

