/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.ControlledPopulationIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.ImpermanentDbmsRule;

public class SchemaIndexWaitingAcceptanceTest {
    private final ControlledPopulationIndexProvider provider = new ControlledPopulationIndexProvider();
    @Rule
    public final DbmsRule rule = new ImpermanentDbmsRule(){

        protected void configure(DatabaseManagementServiceBuilder databaseFactory) {
            super.configure(databaseFactory);
            List<ExtensionFactory> extensions = Collections.singletonList(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"test", (IndexProvider)SchemaIndexWaitingAcceptanceTest.this.provider));
            ((TestDatabaseManagementServiceBuilder)databaseFactory).setExtensions(extensions).noOpSystemGraphInitializer();
        }
    }.withSetting(GraphDatabaseSettings.default_schema_provider, (Object)this.provider.getProviderDescriptor().name());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWaitingForIndexToComeOnline() {
        IndexDefinition index;
        GraphDatabaseAPI db = this.rule.getGraphDatabaseAPI();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = db.beginTx();){
            index = tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        try {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexOnline(index, 1L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected IllegalStateException to be thrown");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWaitingForIndexByNameToComeOnline() {
        GraphDatabaseAPI db = this.rule.getGraphDatabaseAPI();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").withName("my_index").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        try {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexOnline("my_index", 1L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected IllegalStateException to be thrown");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWaitingForAllIndexesToComeOnline() {
        GraphDatabaseAPI db = this.rule.getGraphDatabaseAPI();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        latch.waitForAllToStart();
        try {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected IllegalStateException to be thrown");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
        }
    }
}

