/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DropBrokenUniquenessConstraintIT {
    private final Label label = Label.label((String)"Label");
    private final String key = "key";
    @Inject
    private GraphDatabaseAPI db;

    DropBrokenUniquenessConstraintIT() {
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexNotInUse() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaRuleAccess schemaRules = storageEngine.testAccessSchemaRules();
        schemaRules.indexesGetAll().forEachRemaining(arg_0 -> ((SchemaRuleAccess)schemaRules).deleteSchemaRule(arg_0));
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertFalse((boolean)tx.schema().getConstraints().iterator().hasNext());
            Assertions.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexHavingNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaRuleAccess schemaRules = storageEngine.testAccessSchemaRules();
        this.writeSchemaRulesWithoutConstraint(schemaRules);
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertFalse((boolean)tx.schema().getConstraints().iterator().hasNext());
            Assertions.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissing() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaRuleAccess schemaRules = storageEngine.testAccessSchemaRules();
        schemaRules.constraintsGetAllIgnoreMalformed().forEachRemaining(arg_0 -> ((SchemaRuleAccess)schemaRules).deleteSchemaRule(arg_0));
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertFalse((boolean)tx.schema().getConstraints().iterator().hasNext());
            Assertions.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissingAndIndexHasNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaRuleAccess schemaRules = storageEngine.testAccessSchemaRules();
        schemaRules.constraintsGetAllIgnoreMalformed().forEachRemaining(arg_0 -> ((SchemaRuleAccess)schemaRules).deleteSchemaRule(arg_0));
        this.writeSchemaRulesWithoutConstraint(schemaRules);
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertFalse((boolean)tx.schema().getConstraints().iterator().hasNext());
            Assertions.assertFalse((boolean)tx.schema().getIndexes().iterator().hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void writeSchemaRulesWithoutConstraint(SchemaRuleAccess schemaRules) throws KernelException {
        for (IndexDescriptor rule : Iterators.loop((Iterator)schemaRules.indexesGetAll())) {
            schemaRules.writeSchemaRule((SchemaRule)rule);
        }
    }
}

