/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.EntityTest;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.DoubleLatch;

public class NodeEntityTest
extends EntityTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";

    @Override
    protected long createEntity(Transaction tx) {
        return tx.createNode().getId();
    }

    @Override
    protected Entity lookupEntity(Transaction transaction, long id) {
        return transaction.getNodeById(id);
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() {
        this.createNodeWith("PROPERTY_KEY");
        NotFoundException exception = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                node.getProperty("PROPERTY_KEY");
            }
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
    }

    @Test
    void createDropNodeLongStringProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            Assertions.assertEquals((Object)propertyValue, (Object)node.getProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createDropNodeLongArrayProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        byte[] propertyValue = RandomUtils.nextBytes((int)1024);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            Assertions.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])node.getProperty(testPropertyKey)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test
    void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            try {
                tx.getNodeById(node.getId()).delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.commit();
        }
        MatcherAssert.assertThat((Object)exceptionThrownBySecondDelete, (Matcher)Matchers.instanceOf(NotFoundException.class));
        Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId());
                tx.commit();
            }
        });
    }

    @Test
    void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId()).delete();
                tx.commit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void getAllPropertiesShouldWorkFineWithConcurrentPropertyModifications() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.named((String)"Test-executor-thread"));
        try {
            long nodeId;
            int propertiesCount = 100;
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                nodeId = node.getId();
                for (int i = 0; i < 100; ++i) {
                    node.setProperty("property-" + i, (Object)i);
                }
                tx.commit();
            }
            CountDownLatch start = new CountDownLatch(1);
            AtomicBoolean writerDone = new AtomicBoolean();
            Runnable writer = () -> {
                try {
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    int propertyKey = 0;
                    while (propertyKey < 100) {
                        Transaction tx = this.db.beginTx();
                        try {
                            Node node = tx.getNodeById(nodeId);
                            for (int i = 0; i < 10 && propertyKey < 100; ++i, ++propertyKey) {
                                node.setProperty("property-" + propertyKey, (Object)UUID.randomUUID().toString());
                            }
                            tx.commit();
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                }
                finally {
                    writerDone.set(true);
                }
            };
            Runnable reader = () -> {
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.getNodeById(nodeId);
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    while (!writerDone.get()) {
                        int size = node.getAllProperties().size();
                        MatcherAssert.assertThat((Object)size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    }
                    tx.commit();
                }
            };
            Future<?> readerFuture = executor.submit(reader);
            Future<?> writerFuture = executor.submit(writer);
            start.countDown();
            writerFuture.get();
            readerFuture.get();
            try (Transaction tx = this.db.beginTx();){
                Assertions.assertEquals((int)100, (int)tx.getNodeById(nodeId).getAllProperties().size());
                tx.commit();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldBeAbleToForceTypeChangeOfProperty() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty("prop", (Object)1337);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("prop", (Object)1337.0);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(node.getId()).getProperty("prop"), (Matcher)Matchers.instanceOf(Double.class));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldOnlyReturnTypeOnce() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)tx.getNodeById(node.getId()).getRelationshipTypes()), (Matcher)Matchers.equalTo(Collections.singletonList(RelationshipType.withName((String)"R"))));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowCorrectExceptionOnLabelTokensExceeded() throws KernelException {
        InternalTransaction transaction = this.mockedTransactionWithDepletedTokens();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.addLabel(Label.label((String)"Label")));
    }

    @Test
    void shouldThrowCorrectExceptionOnPropertyKeyTokensExceeded() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(this.mockedTransactionWithDepletedTokens(), 5L);
        Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    @Test
    void shouldThrowCorrectExceptionOnRelationshipTypeTokensExceeded() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(this.mockedTransactionWithDepletedTokens(), 5L);
        Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, (Object)1);
            tx.commit();
        }
    }
}

