/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public class ManagedTestCursors
implements CursorFactory {
    private List<Cursor> allCursors = new ArrayList<Cursor>();
    private CursorFactory cursors;

    ManagedTestCursors(CursorFactory c) {
        this.cursors = c;
    }

    void assertAllClosedAndReset() {
        for (Cursor n : this.allCursors) {
            if (n.isClosed()) continue;
            Assertions.fail((String)("The Cursor " + n.toString() + " was not closed properly."));
        }
        this.allCursors.clear();
    }

    public NodeCursor allocateNodeCursor() {
        NodeCursor n = this.cursors.allocateNodeCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeCursor allocateFullAccessNodeCursor() {
        NodeCursor n = this.cursors.allocateFullAccessNodeCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateRelationshipScanCursor() {
        RelationshipScanCursor n = this.cursors.allocateRelationshipScanCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor() {
        RelationshipScanCursor n = this.cursors.allocateFullAccessRelationshipScanCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        RelationshipTraversalCursor n = this.cursors.allocateRelationshipTraversalCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocatePropertyCursor() {
        PropertyCursor n = this.cursors.allocatePropertyCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocateFullAccessPropertyCursor() {
        PropertyCursor n = this.cursors.allocateFullAccessPropertyCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipGroupCursor allocateRelationshipGroupCursor() {
        RelationshipGroupCursor n = this.cursors.allocateRelationshipGroupCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor() {
        NodeValueIndexCursor n = this.cursors.allocateNodeValueIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor() {
        NodeLabelIndexCursor n = this.cursors.allocateNodeLabelIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor() {
        RelationshipIndexCursor n = this.cursors.allocateRelationshipIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }
}

