/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class NodeValueIndexCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final int TOTAL_NODE_COUNT = 37;
    private static final String COMPOSITE_INDEX_NAME = "compositeIndex";
    private static final String NODE_PROP_INDEX_NAME = "nodeProp";
    private static final String NODE_PROP_2_INDEX_NAME = "nodeProp2";
    private static final String NODE_PROP_3_INDEX_NAME = "nodeProp3";
    private static final String WHAT_EVER_INDEX_NAME = "whatEver";
    private static long strOne;
    private static long strTwo1;
    private static long strTwo2;
    private static long strThree1;
    private static long strThree2;
    private static long strThree3;
    private static long boolTrue;
    private static long num5;
    private static long num6;
    private static long num12a;
    private static long num12b;
    private static long strOneNoLabel;
    private static long joeDalton;
    private static long williamDalton;
    private static long jackDalton;
    private static long averellDalton;
    private static long date891;
    private static long date892;
    private static long date86;
    private static long[] nodesOfAllPropertyTypes;
    private static long whateverPoint;
    private static final PointValue POINT_1;
    private static final PointValue POINT_2;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName(NODE_PROP_INDEX_NAME).create();
            tx.schema().indexFor(Label.label((String)"Node")).on("prop2").withName(NODE_PROP_2_INDEX_NAME).create();
            tx.schema().indexFor(Label.label((String)"Node")).on("prop3").withName(NODE_PROP_3_INDEX_NAME).create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().indexFor(Label.label((String)"What")).on("ever").withName(WHAT_EVER_INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try {
            tx = graphDb.beginTx();
            try {
                tx.schema().indexFor(Label.label((String)"Person")).on("firstname").on("surname").withName(COMPOSITE_INDEX_NAME).create();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            strOne = this.nodeWithProp(tx, "one");
            strTwo1 = this.nodeWithProp(tx, "two");
            strTwo2 = this.nodeWithProp(tx, "two");
            strThree1 = this.nodeWithProp(tx, "three");
            strThree2 = this.nodeWithProp(tx, "three");
            strThree3 = this.nodeWithProp(tx, "three");
            this.nodeWithProp(tx, false);
            boolTrue = this.nodeWithProp(tx, true);
            this.nodeWithProp(tx, 3);
            this.nodeWithProp(tx, 3);
            this.nodeWithProp(tx, 3);
            this.nodeWithProp(tx, 2);
            this.nodeWithProp(tx, 2);
            this.nodeWithProp(tx, 1);
            this.nodeWithProp(tx, 4);
            num5 = this.nodeWithProp(tx, 5);
            num6 = this.nodeWithProp(tx, 6);
            num12a = this.nodeWithProp(tx, 12.0);
            num12b = this.nodeWithProp(tx, 12.0);
            this.nodeWithProp(tx, 18);
            this.nodeWithProp(tx, 24);
            this.nodeWithProp(tx, 30);
            this.nodeWithProp(tx, 36);
            this.nodeWithProp(tx, 42);
            strOneNoLabel = this.nodeWithNoLabel(tx, "one");
            joeDalton = this.person(tx, "Joe", "Dalton");
            williamDalton = this.person(tx, "William", "Dalton");
            jackDalton = this.person(tx, "Jack", "Dalton");
            averellDalton = this.person(tx, "Averell", "Dalton");
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 1.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}));
            this.nodeWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{0.0, 0.0, 0.0}));
            date891 = this.nodeWithProp(tx, DateValue.date((int)1989, (int)3, (int)24));
            date86 = this.nodeWithProp(tx, DateValue.date((int)1986, (int)11, (int)18));
            date892 = this.nodeWithProp(tx, DateValue.date((int)1989, (int)3, (int)24));
            this.nodeWithProp(tx, new String[]{"first", "second", "third"});
            this.nodeWithProp(tx, new String[]{"fourth", "fifth", "sixth", "seventh"});
            MutableLongList listOfIds = LongLists.mutable.empty();
            listOfIds.add(this.nodeWithWhatever(tx, "string"));
            listOfIds.add(this.nodeWithWhatever(tx, false));
            listOfIds.add(this.nodeWithWhatever(tx, 3));
            listOfIds.add(this.nodeWithWhatever(tx, 13.0));
            whateverPoint = this.nodeWithWhatever(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 0.0}));
            listOfIds.add(whateverPoint);
            listOfIds.add(this.nodeWithWhatever(tx, DateValue.date((int)1989, (int)3, (int)24)));
            listOfIds.add(this.nodeWithWhatever(tx, new String[]{"first", "second", "third"}));
            nodesOfAllPropertyTypes = listOfIds.toArray();
            this.assertSameDerivedValue(POINT_1, POINT_2);
            this.nodeWithProp(tx, "prop3", POINT_1.asObjectCopy());
            this.nodeWithProp(tx, "prop3", POINT_2.asObjectCopy());
            this.nodeWithProp(tx, "prop3", POINT_2.asObjectCopy());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    protected abstract String providerKey();

    protected abstract String providerVersion();

    protected boolean indexProvidesStringValues() {
        return false;
    }

    protected boolean indexProvidesNumericValues() {
        return false;
    }

    protected boolean indexProvidesArrayValues() {
        return false;
    }

    protected boolean indexProvidesBooleanValues() {
        return false;
    }

    protected boolean indexProvidesTemporalValues() {
        return true;
    }

    protected abstract void assertSameDerivedValue(PointValue var1, PointValue var2);

    protected boolean indexProvidesSpatialValues() {
        return false;
    }

    protected boolean indexProvidesAllValues() {
        return false;
    }

    @Test
    void shouldPerformExactLookup() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME));
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"zero")});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, new long[0]);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, strOne);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"two")});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, strTwo1, strTwo2);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"three")});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)1)});
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)2)});
            this.assertFoundNodesAndNoValue(node, 2, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)3)});
            this.assertFoundNodesAndNoValue(node, 3, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)6)});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, num6);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)12.0)});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, num12a, num12b);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)true)});
            this.assertFoundNodesAndNoValue(node, (MutableLongSet)uniqueIds, boolTrue);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 3, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{0.0, 0.0, 0.0}))});
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)DateValue.date((int)1989, (int)3, (int)24))});
            this.assertFoundNodesAndNoValue(node, 2, (MutableLongSet)uniqueIds);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)DateValue.date((int)1986, (int)11, (int)18))});
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
        }
    }

    @Test
    void shouldPerformExactLookupInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Joe"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)2));
            this.assertFoundNodesAndNoValue(node, 1, (MutableLongSet)uniqueIds);
        }
    }

    @Test
    void shouldPerformStringPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability stringCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"t"))});
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strTwo1, strTwo2, strThree1, strThree2, strThree3);
        }
    }

    @Test
    void shouldPerformStringSuffixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability stringCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringSuffix((int)prop, (TextValue)Values.stringValue((String)"e"))});
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strOne, strThree1, strThree2, strThree3);
        }
    }

    @Test
    void shouldPerformStringContainmentSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability stringCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringContains((int)prop, (TextValue)Values.stringValue((String)"o"))});
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strOne, strTwo1, strTwo2);
        }
    }

    @Test
    void shouldPerformStringRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability stringCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strOne, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strOne);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"three", (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)false, (String)"two", (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strThree1, strThree2, strThree3);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, stringCapability, needsValues, strOne, strThree1, strThree2, strThree3, strTwo1, strTwo2);
        }
    }

    @Test
    void shouldPerformNumericRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesNumericValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability numberCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.NUMBER});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, numberCapability, needsValues, num5, num6, num12a, num12b);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)true, (Number)12, (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, numberCapability, needsValues, num5, num6);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, numberCapability, needsValues, num6, num12a, num12b);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Number)5, (boolean)false, (Number)12, (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, numberCapability, needsValues, num6);
        }
    }

    @Test
    void shouldPerformTemporalRangeSearch() throws KernelException {
        boolean needsValues = this.indexProvidesTemporalValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability temporalCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.TEMPORAL});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, temporalCapability, needsValues, date86, date891, date892);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, temporalCapability, needsValues, date86);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, temporalCapability, needsValues, date891, date892);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)false, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)false)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, temporalCapability, needsValues, new long[0]);
        }
    }

    @Test
    void shouldPerformSpatialRangeSearch() throws KernelException {
        boolean needsValues = this.indexProvidesSpatialValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability spatialCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.GEOMETRY});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian)});
            this.assertFoundNodesAndValue(node, 5, (MutableLongSet)uniqueIds, spatialCapability, needsValues);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D)});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, spatialCapability, needsValues);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84)});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, spatialCapability, needsValues);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D)});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, spatialCapability, needsValues);
        }
    }

    @Test
    void shouldPerformBooleanSearch() throws KernelException {
        boolean needsValues = this.indexProvidesBooleanValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability capability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueGroup.BOOLEAN.category()});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)false)});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, capability, needsValues);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)true)});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, capability, needsValues);
        }
    }

    @Test
    void shouldPerformTextArraySearch() throws KernelException {
        boolean needsValues = this.indexProvidesArrayValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability capability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueGroup.TEXT_ARRAY.category()});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)new String[]{"first", "second", "third"})});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, capability, needsValues);
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)new String[]{"fourth", "fifth", "sixth", "seventh"})});
            this.assertFoundNodesAndValue(node, 1, (MutableLongSet)uniqueIds, capability, needsValues);
        }
    }

    @Test
    void shouldPerformIndexScan() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability wildcardCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexScan(index, node, IndexOrder.NONE, this.indexProvidesAllValues());
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, 37, (MutableLongSet)uniqueIds, wildcardCapability, this.indexProvidesAllValues());
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForNumbers() throws Exception {
        boolean needsValues = this.indexProvidesNumericValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.NUMBER});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Number)1, (boolean)true, (Number)42, (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForStrings() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.TEXT});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"two", (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForTemporal() throws KernelException {
        boolean needsValues = this.indexProvidesTemporalValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.TEMPORAL});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)DateValue.date((int)1986, (int)11, (int)18), (boolean)true, (Value)DateValue.date((int)1989, (int)3, (int)24), (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForSpatial() throws KernelException {
        boolean needsValues = this.indexProvidesSpatialValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.GEOMETRY});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForStringArray() throws KernelException {
        boolean needsValues = this.indexProvidesSpatialValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.TEXT_ARRAY});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (Value)Values.of((Object)new String[]{"first", "second", "third"}), (boolean)true, (Value)Values.of((Object)new String[]{"fourth", "fifth", "sixth", "seventh"}), (boolean)true)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldRespectOrderCapabilitiesForWildcard() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexOrder[] orderCapabilities = index.reference().getCapability().orderCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            for (IndexOrder orderCapability : orderCapabilities) {
                this.read.nodeIndexSeek(index, node, orderCapability, needsValues, new IndexQuery[]{IndexQuery.exists((int)prop)});
                this.assertFoundNodesInOrder(node, orderCapability);
            }
        }
    }

    @Test
    void shouldProvideValuesForPoints() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexProvidesSpatialValues());
        int prop = this.token.propertyKey("ever");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(WHAT_EVER_INDEX_NAME));
        Assertions.assertEquals((Object)IndexValueCapability.YES, (Object)index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.GEOMETRY}));
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, true, new IndexQuery[]{IndexQuery.range((int)prop, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.GEOMETRY}), true, whateverPoint);
        }
    }

    @Test
    void shouldProvideValuesForAllTypes() throws Exception {
        Assumptions.assumeTrue((boolean)this.indexProvidesAllValues());
        int prop = this.token.propertyKey("ever");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(WHAT_EVER_INDEX_NAME));
        IndexValueCapability valueCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        Assertions.assertEquals((Object)IndexValueCapability.YES, (Object)valueCapability);
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            this.read.nodeIndexSeek(index, node, IndexOrder.NONE, true, new IndexQuery[]{IndexQuery.exists((int)prop)});
            this.assertFoundNodesAndValue(node, (MutableLongSet)uniqueIds, valueCapability, true, nodesOfAllPropertyTypes);
        }
    }

    private void assertFoundNodesInOrder(NodeValueIndexCursor node, IndexOrder indexOrder) {
        Value currentValue = null;
        while (node.next()) {
            long nodeReference = node.nodeReference();
            Value storedValue = this.getPropertyValueFromStore(nodeReference);
            if (currentValue != null) {
                switch (indexOrder) {
                    case ASCENDING: {
                        Assertions.assertTrue((Values.COMPARATOR.compare(currentValue, storedValue) <= 0 ? 1 : 0) != 0, (String)("Requested ordering " + indexOrder + " was not respected."));
                        break;
                    }
                    case DESCENDING: {
                        Assertions.assertTrue((Values.COMPARATOR.compare(currentValue, storedValue) >= 0 ? 1 : 0) != 0, (String)("Requested ordering " + indexOrder + " was not respected."));
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can not verify ordering for " + indexOrder);
                    }
                }
            }
            currentValue = storedValue;
        }
    }

    private void assertFoundNodesAndValue(NodeValueIndexCursor node, int nodes, MutableLongSet uniqueIds, IndexValueCapability expectValue, boolean indexProvidesValues) {
        uniqueIds.clear();
        for (int i = 0; i < nodes; ++i) {
            Assertions.assertTrue((boolean)node.next(), (String)("at least " + nodes + " nodes, was " + uniqueIds.size()));
            long nodeReference = node.nodeReference();
            Assertions.assertTrue((boolean)uniqueIds.add(nodeReference), (String)"all nodes are unique");
            if (IndexValueCapability.YES.equals((Object)expectValue)) {
                Assertions.assertTrue((boolean)node.hasValue(), (String)("Value capability said index would have value for " + expectValue + ", but didn't"));
            }
            if (!indexProvidesValues) continue;
            Assertions.assertTrue((boolean)node.hasValue(), (String)"Index did not provide values");
            Value storedValue = this.getPropertyValueFromStore(nodeReference);
            MatcherAssert.assertThat((String)"has correct value", (Object)node.propertyValue(0), (Matcher)CoreMatchers.is((Object)storedValue));
        }
        Assertions.assertFalse((boolean)node.next(), (String)("no more than " + nodes + " nodes"));
    }

    private void assertFoundNodesAndNoValue(NodeValueIndexCursor node, int nodes, MutableLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < nodes; ++i) {
            Assertions.assertTrue((boolean)node.next(), (String)("at least " + nodes + " nodes, was " + uniqueIds.size()));
            long nodeReference = node.nodeReference();
            Assertions.assertTrue((boolean)uniqueIds.add(nodeReference), (String)"all nodes are unique");
        }
        Assertions.assertFalse((boolean)node.next(), (String)("no more than " + nodes + " nodes"));
    }

    private void assertFoundNodesAndValue(NodeValueIndexCursor node, MutableLongSet uniqueIds, IndexValueCapability expectValue, boolean indexProvidesValues, long ... expected) {
        this.assertFoundNodesAndValue(node, expected.length, uniqueIds, expectValue, indexProvidesValues);
        for (long expectedNode : expected) {
            Assertions.assertTrue((boolean)uniqueIds.contains(expectedNode), (String)("expected node " + expectedNode));
        }
    }

    private void assertFoundNodesAndNoValue(NodeValueIndexCursor node, MutableLongSet uniqueIds, long ... expected) {
        this.assertFoundNodesAndNoValue(node, expected.length, uniqueIds);
        for (long expectedNode : expected) {
            Assertions.assertTrue((boolean)uniqueIds.contains(expectedNode), (String)("expected node " + expectedNode));
        }
    }

    private Value getPropertyValueFromStore(long nodeReference) {
        try (NodeCursor storeCursor = this.cursors.allocateNodeCursor();){
            Value value;
            block12: {
                PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor();
                try {
                    this.read.singleNode(nodeReference, storeCursor);
                    storeCursor.next();
                    storeCursor.properties(propertyCursor);
                    propertyCursor.next();
                    value = propertyCursor.propertyValue();
                    if (propertyCursor == null) break block12;
                }
                catch (Throwable throwable) {
                    if (propertyCursor != null) {
                        try {
                            propertyCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                propertyCursor.close();
            }
            return value;
        }
    }

    @Test
    void shouldGetNoIndexForMissingTokens() {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        int badLabel = label + 1000;
        int badProp = prop + 1000;
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)badLabel, (int[])new int[]{prop})).hasNext(), (String)"bad label");
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)label, (int[])new int[]{badProp})).hasNext(), (String)"bad prop");
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)badLabel, (int[])new int[]{badProp})).hasNext(), (String)"just bad");
    }

    @Test
    void shouldGetNoIndexForUnknownTokens() {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        int badLabel = Integer.MAX_VALUE;
        int badProp = Integer.MAX_VALUE;
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)badLabel, (int[])new int[]{prop})).hasNext(), (String)"bad label");
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)label, (int[])new int[]{badProp})).hasNext(), (String)"bad prop");
        Assertions.assertFalse((boolean)this.schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)badLabel, (int[])new int[]{badProp})).hasNext(), (String)"just bad");
    }

    @Test
    void shouldGetVersionAndKeyFromIndexReference() {
        IndexDescriptor index = this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME);
        Assertions.assertEquals((Object)this.providerKey(), (Object)index.getIndexProvider().getKey());
        Assertions.assertEquals((Object)this.providerVersion(), (Object)index.getIndexProvider().getVersion());
    }

    @Test
    void shouldNotFindDeletedNodeInIndexScan() throws Exception {
        boolean needsValues = this.indexProvidesAllValues();
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        IndexValueCapability wildcardCapability = index.reference().getCapability().valueCapability(new ValueCategory[]{ValueCategory.UNKNOWN});
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            LongHashSet uniqueIds = new LongHashSet();
            tx.dataRead().nodeIndexScan(index, node, IndexOrder.NONE, needsValues);
            MatcherAssert.assertThat((Object)node.numberOfProperties(), (Matcher)CoreMatchers.equalTo((Object)1));
            this.assertFoundNodesAndValue(node, 37, (MutableLongSet)uniqueIds, wildcardCapability, needsValues);
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexScan(index, node, IndexOrder.NONE, needsValues);
            this.assertFoundNodesAndValue(node, 36, (MutableLongSet)uniqueIds, wildcardCapability, needsValues);
        }
    }

    @Test
    void shouldNotFindDeletedNodeInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindDNodeWithRemovedLabelInIndexSeek() throws Exception {
        boolean needsValues = false;
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindUpdatedNodeInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInIndexSeek() throws Exception {
        boolean needsValues = false;
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"ett")});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInIndexSeek() throws Exception {
        boolean needsValues = false;
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"one")});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    void shouldNotFindDeletedNodeInRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataWrite().nodeDelete(strThree1);
            tx.dataWrite().nodeDelete(strThree2);
            tx.dataWrite().nodeDelete(strThree3);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindNodeWithRemovedLabelInRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeRemoveLabel(strThree1, label);
            tx.dataWrite().nodeRemoveLabel(strThree2, label);
            tx.dataWrite().nodeRemoveLabel(strThree3, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindUpdatedNodeInRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataWrite().nodeSetProperty(strThree1, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataWrite().nodeSetProperty(strThree2, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataWrite().nodeSetProperty(strThree3, prop, (Value)Values.stringValue((String)"tre"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"three", (boolean)true)});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"ett", (boolean)true, (String)"tre", (boolean)true)});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInRangeSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.range((int)prop, (String)"one", (boolean)true, (String)"ones", (boolean)true)});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindDeletedNodeInPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(strOne);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindNodeWithRemovedLabelInPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindUpdatedNodeInPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(strOne, prop, (Value)Values.stringValue((String)"ett"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"et"))});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOne, (long)node.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInPrefixSearch() throws Exception {
        boolean needsValues = this.indexProvidesStringValues();
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(NODE_PROP_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(strOne, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"on"))});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    void shouldNotFindDeletedNodeInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeDelete(jackDalton);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jack"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindNodeWithRemovedLabelInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(joeDalton, label);
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Joe"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldNotFindUpdatedNodeInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(jackDalton, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(jackDalton, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jack"), IndexQuery.exact((int)surname, (Object)"Dalton")});
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeSetProperty(jackDalton, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(jackDalton, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jesse"), IndexQuery.exact((int)surname, (Object)"James")});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)jackDalton, (long)node.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInCompositeIndex() throws Exception {
        boolean needsValues = false;
        int label = this.token.nodeLabel("Person");
        int firstName = this.token.propertyKey("firstname");
        int surname = this.token.propertyKey("surname");
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(COMPOSITE_INDEX_NAME));
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(joeDalton, label);
            tx.dataWrite().nodeAddLabel(strOneNoLabel, label);
            tx.dataWrite().nodeSetProperty(strOneNoLabel, firstName, (Value)Values.stringValue((String)"Jesse"));
            tx.dataWrite().nodeSetProperty(strOneNoLabel, surname, (Value)Values.stringValue((String)"James"));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.NONE, needsValues, new IndexQuery[]{IndexQuery.exact((int)firstName, (Object)"Jesse"), IndexQuery.exact((int)surname, (Object)"James")});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertEquals((long)strOneNoLabel, (long)node.nodeReference());
        }
    }

    @Test
    void shouldCountDistinctValues() throws Exception {
        int label = this.token.nodeLabel("Node");
        int key = this.token.propertyKey("prop2");
        IndexDescriptor index = this.schemaRead.indexGetForName(NODE_PROP_2_INDEX_NAME);
        int expectedCount = 100;
        HashMap<Value, Set> expected = new HashMap<Value, Set>();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < expectedCount; ++i) {
                Object value = random.nextBoolean() ? String.valueOf(i % 10) : Integer.valueOf(i % 10);
                long nodeId = write.nodeCreate();
                write.nodeAddLabel(nodeId, label);
                write.nodeSetProperty(nodeId, key, Values.of((Object)value));
                expected.computeIfAbsent(Values.of((Object)value), v -> new HashSet()).add(nodeId);
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexDistinctValues(index, node, true);
            long totalCount = 0L;
            boolean hasValues = true;
            while (node.next()) {
                long count = node.nodeReference();
                if (node.hasValue() && node.propertyValue(0) != null) {
                    Value value = node.propertyValue(0);
                    Set expectedNodes = (Set)expected.remove(value);
                    Assertions.assertNotNull((Object)expectedNodes);
                    Assertions.assertEquals((long)count, (long)expectedNodes.size());
                } else {
                    hasValues = false;
                }
                totalCount += count;
            }
            if (hasValues) {
                Assertions.assertTrue((boolean)expected.isEmpty(), (String)((Object)expected).toString());
            }
            Assertions.assertEquals((long)expectedCount, (long)totalCount);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCountDistinctButSimilarPointValues() throws Exception {
        IndexDescriptor index = this.schemaRead.indexGetForName(NODE_PROP_3_INDEX_NAME);
        HashMap<PointValue, Integer> expected = new HashMap<PointValue, Integer>();
        expected.put(POINT_1, 1);
        expected.put(POINT_2, 2);
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexDistinctValues(index, node, true);
            while (node.next()) {
                Assertions.assertTrue((boolean)node.hasValue());
                Assertions.assertTrue((boolean)expected.containsKey(node.propertyValue(0)));
                Assertions.assertEquals((int)((Integer)expected.remove(node.propertyValue(0))), (int)Math.toIntExact(node.nodeReference()));
            }
            Assertions.assertTrue((boolean)expected.isEmpty());
        }
    }

    @Test
    void shouldHandleOrderedExactSeekWithNeedsValuesTrue() throws Exception {
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME));
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            this.read.nodeIndexSeek(index, node, IndexOrder.ASCENDING, true, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)5)});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertTrue((boolean)node.hasValue());
            Assertions.assertEquals((Object)node.propertyValue(0), (Object)Values.intValue((int)5));
            Assertions.assertFalse((boolean)node.next());
        }
    }

    @Test
    void shouldHandleOrderedExactSeekWithNeedsValuesTrueWithTxChanges() throws Exception {
        int prop = this.token.propertyKey("prop");
        IndexReadSession index = this.tx.dataRead().indexReadSession(this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME));
        int label = this.token.nodeLabel("Node");
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            long newNode = tx.dataWrite().nodeCreateWithLabels(new int[]{label});
            tx.dataWrite().nodeSetProperty(newNode, prop, (Value)Values.intValue((int)5));
            tx.dataRead().nodeIndexSeek(index, node, IndexOrder.ASCENDING, true, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)5)});
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertTrue((boolean)node.hasValue());
            Assertions.assertEquals((Object)node.propertyValue(0), (Object)Values.intValue((int)5));
            Assertions.assertTrue((boolean)node.next());
            Assertions.assertTrue((boolean)node.hasValue());
            Assertions.assertEquals((Object)node.propertyValue(0), (Object)Values.intValue((int)5));
            Assertions.assertFalse((boolean)node.next());
        }
    }

    private long nodeWithProp(Transaction tx, Object value) {
        return this.nodeWithProp(tx, "prop", value);
    }

    private long nodeWithProp(Transaction tx, String key, Object value) {
        Node node = tx.createNode(new Label[]{Label.label((String)"Node")});
        node.setProperty(key, value);
        return node.getId();
    }

    private long nodeWithWhatever(Transaction tx, Object value) {
        Node node = tx.createNode(new Label[]{Label.label((String)"What")});
        node.setProperty("ever", value);
        return node.getId();
    }

    private long nodeWithNoLabel(Transaction tx, Object value) {
        Node node = tx.createNode();
        node.setProperty("prop", value);
        return node.getId();
    }

    private long person(Transaction tx, String firstName, String surname) {
        Node node = tx.createNode(new Label[]{Label.label((String)"Person")});
        node.setProperty("firstname", (Object)firstName);
        node.setProperty("surname", (Object)surname);
        return node.getId();
    }

    static {
        POINT_1 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.0060, crs: 'wgs-84'}");
        POINT_2 = PointValue.parse((CharSequence)"{latitude: 40.7128, longitude: -74.006000001, crs: 'wgs-84'}");
    }
}

