/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class NeoStoresIT {
    @Inject
    private GraphDatabaseService db;
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"FRIEND");
    private static final String LONG_STRING_VALUE = "ALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALONG!!";

    NeoStoresIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)1);
    }

    @Test
    void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.getNodeById(latestNodeId[0]);
                for (String propertyKey : node.getPropertyKeys()) {
                    node.getProperty(propertyKey);
                }
                tx.commit();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    void shouldWriteOutThePropertyRecordBeforeReferencingItFromANodeRecord() throws Throwable {
        Race race = new Race();
        long[] latestNodeId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                latestNodeId[0] = node.getId();
                node.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block9: {
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.getNodeById(latestNodeId[0]);
                    for (String propertyKey : node.getPropertyKeys()) {
                        node.getProperty(propertyKey);
                    }
                    tx.commit();
                }
                catch (NotFoundException e) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, InvalidRecordException.class) == -1) break block9;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }

    @Test
    void shouldWriteOutThePropertyRecordBeforeReferencingItFromARelationshipRecord() throws Throwable {
        long node2Id;
        long node1Id;
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.createNode();
            node1Id = node1.getId();
            Node node2 = tx.createNode();
            node2Id = node2.getId();
            tx.commit();
        }
        Race race = new Race();
        long[] latestRelationshipId = new long[1];
        AtomicLong writes = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        race.withEndCondition(new BooleanSupplier[]{() -> writes.get() > 100L && reads.get() > 10000L || System.currentTimeMillis() > endTime});
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node1 = tx.getNodeById(node1Id);
                Node node2 = tx.getNodeById(node2Id);
                Relationship rel = node1.createRelationshipTo(node2, FRIEND);
                latestRelationshipId[0] = rel.getId();
                rel.setProperty("largeProperty", (Object)LONG_STRING_VALUE);
                tx.commit();
            }
            writes.incrementAndGet();
        });
        race.addContestant(() -> {
            block9: {
                try (Transaction tx = this.db.beginTx();){
                    Relationship rel = tx.getRelationshipById(latestRelationshipId[0]);
                    for (String propertyKey : rel.getPropertyKeys()) {
                        rel.getProperty(propertyKey);
                    }
                    tx.commit();
                }
                catch (NotFoundException e) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)e, InvalidRecordException.class) == -1) break block9;
                    throw e;
                }
            }
            reads.incrementAndGet();
        });
        race.go();
    }
}

