/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionMetaDataStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class TransactionLogInitializerTest {
    @Inject
    private TestDirectory testDirectory;

    TransactionLogInitializerTest() {
    }

    @Test
    void shouldResetMetaDataStoreWithTransactionId() throws Exception {
        TransactionMetaDataStore metaStore = (TransactionMetaDataStore)Mockito.mock(TransactionMetaDataStore.class);
        TransactionId txn = new TransactionId(3L, -1322858814, System.currentTimeMillis());
        Mockito.when((Object)metaStore.getStoreId()).thenReturn((Object)new StoreId(MetaDataStore.versionStringToLong((String)Standard.LATEST_STORE_VERSION)));
        Mockito.when((Object)metaStore.getLastClosedTransaction()).thenReturn((Object)new long[]{txn.transactionId(), 0L, 1613L});
        Mockito.when((Object)metaStore.getLastCommittedTransaction()).thenReturn((Object)txn);
        Mockito.when((Object)metaStore.getLastCommittedTransactionId()).thenReturn((Object)txn.transactionId());
        Mockito.when((Object)metaStore.getLastClosedTransactionId()).thenReturn((Object)txn.transactionId());
        DatabaseLayout databaseLayout = Neo4jLayout.of((File)this.testDirectory.homeDir()).databaseLayout("neo4j");
        TransactionLogInitializer initializer = new TransactionLogInitializer(this.testDirectory.getFileSystem(), metaStore);
        initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory());
        ((TransactionMetaDataStore)Mockito.verify((Object)metaStore)).resetLastClosedTransaction(txn.transactionId(), txn.transactionId(), 64L, true);
    }
}

