/*
 * Decompiled with CFR 0.152.
 */
package migration;

import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class RecordFormatMigrationIT {
    @Inject
    private TestDirectory testDirectory;
    private File databaseDirectory;

    RecordFormatMigrationIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseDirectory = this.testDirectory.homeDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToDowngradeFormatWhenUpgradeNotAllowed() {
        DatabaseManagementService managementService = this.startManagementService("standardV3_4_0");
        GraphDatabaseAPI database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        managementService.shutdown();
        managementService = this.startManagementService("standard");
        database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try {
            Throwable throwable = this.assertDefaultDatabaseFailed(database);
            Assertions.assertSame(UpgradeNotAllowedException.class, ExceptionUtils.getRootCause((Throwable)throwable).getClass());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToDowngradeFormatWheUpgradeAllowed() {
        DatabaseManagementService managementService = this.startManagementService("standard");
        GraphDatabaseAPI database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        managementService.shutdown();
        managementService = RecordFormatMigrationIT.startDatabaseServiceWithUpgrade(this.databaseDirectory, "standardV3_4_0");
        database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try {
            Throwable throwable = this.assertDefaultDatabaseFailed(database);
            Assertions.assertSame(StoreUpgrader.AttemptedDowngradeException.class, ExceptionUtils.getRootCause((Throwable)throwable).getClass());
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void skipMigrationIfFormatSpecifiedInConfig() {
        DatabaseManagementService managementService = this.startManagementService("standardV3_4_0");
        GraphDatabaseAPI database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        managementService.shutdown();
        managementService = this.startManagementService("standardV3_4_0");
        GraphDatabaseAPI nonUpgradedStore = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        RecordStorageEngine storageEngine = (RecordStorageEngine)nonUpgradedStore.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        Assertions.assertEquals((Object)"standardV3_4_0", (Object)storageEngine.testAccessNeoStores().getRecordFormats().name());
        managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void requestMigrationIfStoreFormatNotSpecifiedButIsAvailableInRuntime() {
        DatabaseManagementService managementService = this.startManagementService("standardV3_4_0");
        GraphDatabaseAPI database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        managementService.shutdown();
        managementService = new TestDatabaseManagementServiceBuilder(this.databaseDirectory).build();
        database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try {
            this.assertDefaultDatabaseFailed(database);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void latestRecordNotMigratedWhenFormatBumped() {
        DatabaseManagementService managementService = this.startManagementService("standardV3_4_0");
        GraphDatabaseAPI database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        managementService.shutdown();
        managementService = this.startManagementService("standard");
        database = RecordFormatMigrationIT.getDefaultDatabase(managementService);
        try {
            Throwable exception = this.assertDefaultDatabaseFailed(database);
            Assertions.assertSame(UpgradeNotAllowedException.class, ExceptionUtils.getRootCause((Throwable)exception).getClass());
        }
        finally {
            managementService.shutdown();
        }
    }

    private Throwable assertDefaultDatabaseFailed(GraphDatabaseAPI database) {
        Assertions.assertThrows(Throwable.class, () -> ((GraphDatabaseAPI)database).beginTx());
        DatabaseStateService dbStateService = RecordFormatMigrationIT.getDatabaseStateService(database);
        Optional failure = dbStateService.causeOfFailure(database.databaseId());
        return (Throwable)failure.orElseThrow(() -> new AssertionError((Object)String.format("No failure found for database %s", database.databaseId().name())));
    }

    private static DatabaseStateService getDatabaseStateService(GraphDatabaseAPI databaseService) {
        return (DatabaseStateService)databaseService.getDependencyResolver().resolveDependency(DatabaseStateService.class);
    }

    private static GraphDatabaseAPI getDefaultDatabase(DatabaseManagementService managementService) {
        return (GraphDatabaseAPI)managementService.database("neo4j");
    }

    private DatabaseManagementService startManagementService(String name) {
        return new TestDatabaseManagementServiceBuilder(this.databaseDirectory).setConfig(GraphDatabaseSettings.record_format, (Object)name).build();
    }

    private static DatabaseManagementService startDatabaseServiceWithUpgrade(File storeDir, String formatName) {
        return new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.record_format, (Object)formatName).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
    }
}

