/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;

public class SchemaAcceptanceTestBase {
    protected final String propertyKey = "my_property_key";
    protected final String secondPropertyKey = "my_second_property_key";
    protected Label label = Labels.MY_LABEL;
    protected Label otherLabel = Labels.MY_OTHER_LABEL;
    protected RelationshipType relType = RelationshipType.withName((String)"relType");

    protected <EXCEPTION extends Throwable, CAUSE extends Throwable> void assertExpectedException(Class<CAUSE> expectedCause, String expectedMessage, EXCEPTION exception) {
        Throwable cause = exception.getCause();
        Assertions.assertEquals(expectedCause, cause.getClass(), (String)("Expected cause to be of type " + expectedCause + " but was " + cause.getClass()));
        Assertions.assertEquals((Object)expectedMessage, (Object)exception.getMessage());
    }

    protected static enum SchemaTxStrategy {
        SEPARATE_TX{

            @Override
            public <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService db, Consumer<Schema> firstSchemaRule, Consumer<Schema> secondSchemaRule, Class<EXCEPTION> expectedException) {
                try (Transaction tx = db.beginTx();){
                    firstSchemaRule.accept(tx.schema());
                    tx.commit();
                }
                return (EXCEPTION)Assertions.assertThrows(expectedException, () -> {
                    try (Transaction tx = db.beginTx();){
                        secondSchemaRule.accept(tx.schema());
                        tx.commit();
                    }
                });
            }
        }
        ,
        SAME_TX{

            @Override
            public <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService db, Consumer<Schema> firstSchemaRule, Consumer<Schema> secondSchemaRule, Class<EXCEPTION> expectedException) {
                return (EXCEPTION)Assertions.assertThrows(expectedException, () -> {
                    try (Transaction tx = db.beginTx();){
                        firstSchemaRule.accept(tx.schema());
                        secondSchemaRule.accept(tx.schema());
                        tx.commit();
                    }
                });
            }
        };


        public abstract <EXCEPTION extends Throwable> EXCEPTION execute(GraphDatabaseService var1, Consumer<Schema> var2, Consumer<Schema> var3, Class<EXCEPTION> var4);
    }

    protected static enum Labels implements Label
    {
        MY_LABEL,
        MY_OTHER_LABEL;

    }
}

