/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelAPIParallelStress;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class KernelAPIParallelLabelScanStressIT {
    private static final int N_THREADS = 10;
    private static final int N_NODES = 10000;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule random;

    KernelAPIParallelLabelScanStressIT() {
    }

    @Test
    void shouldDoParallelLabelScans() throws Throwable {
        int[] labels = new int[3];
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx2 = kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            labels[0] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL1");
            labels[1] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL2");
            labels[2] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL3");
            tx2.commit();
        }
        KernelAPIParallelStress.parallelStressInTx(kernel, 10, tx -> tx.cursors().allocateNodeLabelIndexCursor(), (read, cursor) -> this.labelScan((Read)read, (NodeLabelIndexCursor)cursor, labels[this.random.nextInt(labels.length)]));
    }

    private static int createLabeledNodes(KernelTransaction tx, int nNodes, String labelName) throws KernelException {
        int label = tx.tokenWrite().labelCreateForName(labelName, false);
        for (int i = 0; i < nNodes; ++i) {
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, label);
        }
        return label;
    }

    private Runnable labelScan(Read read, NodeLabelIndexCursor cursor, int label) {
        return () -> {
            read.nodeLabelScan(label, cursor);
            int n = 0;
            while (cursor.next()) {
                ++n;
            }
            Assertions.assertEquals((int)10000, (int)n, (String)"correct number of nodes");
        };
    }
}

