/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DatabaseLockIT {
    @Inject
    private DatabaseManagementService managementService;

    DatabaseLockIT() {
    }

    @Test
    void allDatabasesLockedWhenStarted() {
        List databaseNames = this.managementService.listDatabases();
        MatcherAssert.assertThat((Object)databaseNames, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        for (String databaseName : databaseNames) {
            GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database(databaseName);
            Assertions.assertThrows(FileLockException.class, () -> LockChecker.checkDatabaseLock((DatabaseLayout)dbApi.databaseLayout()));
        }
    }

    @Test
    void allDatabaseLocksReleasedWhenStopped() {
        List databaseNames = this.managementService.listDatabases();
        MatcherAssert.assertThat((Object)databaseNames, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        for (String databaseName : databaseNames) {
            GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database(databaseName);
            Database db = (Database)dbApi.getDependencyResolver().resolveDependency(Database.class);
            db.stop();
            Assertions.assertDoesNotThrow(() -> LockChecker.checkDatabaseLock((DatabaseLayout)dbApi.databaseLayout()).close());
        }
    }

    @Test
    void dbmsLockedWhenStarted() {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database("system");
        Neo4jLayout neo4jLayout = dbApi.databaseLayout().getNeo4jLayout();
        Assertions.assertThrows(FileLockException.class, () -> LockChecker.checkDbmsLock((Neo4jLayout)neo4jLayout));
    }

    @Test
    void dbmsLockReleasedWhenStopped() {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database("system");
        Neo4jLayout neo4jLayout = dbApi.databaseLayout().getNeo4jLayout();
        this.managementService.shutdown();
        Assertions.assertDoesNotThrow(() -> LockChecker.checkDbmsLock((Neo4jLayout)neo4jLayout).close());
    }
}

