/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class SchemaReadWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int label;
    private int label2;
    private int type;
    private int prop1;
    private int prop2;
    private int prop3;

    @BeforeEach
    void setUp() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            SchemaWrite schemaWrite = transaction.schemaWrite();
            Iterator constraints = schemaRead.constraintsGetAll();
            while (constraints.hasNext()) {
                schemaWrite.constraintDrop((ConstraintDescriptor)constraints.next());
            }
            Iterator indexes = schemaRead.indexesGetAll();
            while (indexes.hasNext()) {
                schemaWrite.indexDrop((IndexDescriptor)indexes.next());
            }
            TokenWrite tokenWrite = transaction.tokenWrite();
            this.label = tokenWrite.labelGetOrCreateForName("label");
            this.label2 = tokenWrite.labelGetOrCreateForName("label2");
            this.type = tokenWrite.relationshipTypeGetOrCreateForName("relationship");
            this.prop1 = tokenWrite.propertyKeyGetOrCreateForName("prop1");
            this.prop2 = tokenWrite.propertyKeyGetOrCreateForName("prop2");
            this.prop3 = tokenWrite.propertyKeyGetOrCreateForName("prop3");
            transaction.commit();
        }
    }

    @Test
    void shouldNotFindNonExistentIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
    }

    @Test
    void shouldCreateIndex() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            MatcherAssert.assertThat((Object)((IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})))), (Matcher)Matchers.equalTo((Object)index));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void createdIndexShouldPopulateInTx() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor index = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            MatcherAssert.assertThat((Object)tx.schemaRead().indexGetState(index), (Matcher)Matchers.equalTo((Object)InternalIndexState.POPULATING));
            MatcherAssert.assertThat((Object)tx.schemaRead().snapshot().indexGetState(index), (Matcher)Matchers.equalTo((Object)InternalIndexState.POPULATING));
            MatcherAssert.assertThat((Object)before.indexGetState(index), (Matcher)Matchers.equalTo((Object)InternalIndexState.POPULATING));
            tx.commit();
        }
    }

    @Test
    void shouldDropIndex() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropIndexBySchema() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index.schema());
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropInByName() throws Exception {
        String indexName = "My fancy index";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), indexName);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(indexName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropNoIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(IndexDescriptor.NO_INDEX));
            transaction.commit();
        }
    }

    @Test
    void shouldFailToDropNonExistentIndex() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropNonExistentIndexSchema() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index.schema()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropNonExistentIndexByName() throws Exception {
        String indexName = "My fancy index";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), indexName);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(indexName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(indexName));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailIfExistingIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my other index"));
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "my index"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeIndexFromTransaction() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2});
            transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, "my other index");
            SchemaRead schemaRead = transaction.schemaRead();
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)schema));
            MatcherAssert.assertThat((Object)index.schema().getPropertyIds(), (Matcher)Matchers.equalTo((Object)new int[]{this.prop2}));
            MatcherAssert.assertThat((Object)2, (Matcher)Matchers.equalTo((Object)Iterators.asList((Iterator)schemaRead.indexesGetAll()).size()));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeIndexFromTransactionInSnapshot() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index 1");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore schemaReadBefore = transaction.schemaRead().snapshot();
            IndexDescriptor createdIndex = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "my index 2");
            SchemaReadCore schemaReadAfter = transaction.schemaRead().snapshot();
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaReadBefore.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})));
            MatcherAssert.assertThat((Object)index.schema().getPropertyIds(), (Matcher)Matchers.equalTo((Object)new int[]{this.prop2}));
            MatcherAssert.assertThat((Object)2, (Matcher)Matchers.equalTo((Object)Iterators.asList((Iterator)schemaReadBefore.indexesGetAll()).size()));
            MatcherAssert.assertThat((Object)index, (Matcher)Matchers.is((Object)createdIndex));
            MatcherAssert.assertThat((Object)schemaReadBefore.indexGetForName("my index 2"), (Matcher)Matchers.is((Object)createdIndex));
            index = (IndexDescriptor)Iterators.single((Iterator)schemaReadAfter.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})));
            MatcherAssert.assertThat((Object)index.schema().getPropertyIds(), (Matcher)Matchers.equalTo((Object)new int[]{this.prop2}));
            MatcherAssert.assertThat((Object)2, (Matcher)Matchers.equalTo((Object)Iterators.asList((Iterator)schemaReadAfter.indexesGetAll()).size()));
            MatcherAssert.assertThat((Object)index, (Matcher)Matchers.is((Object)createdIndex));
            MatcherAssert.assertThat((Object)schemaReadAfter.indexGetForName("my index 2"), (Matcher)Matchers.is((Object)createdIndex));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedIndexFromTransaction() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().indexDrop(index);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.index(index.schema()).hasNext());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedIndexFromTransactionInSnapshot() throws Exception {
        IndexDescriptor index;
        try (KernelTransaction transaction = this.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore schemaReadBefore = transaction.schemaRead().snapshot();
            transaction.schemaWrite().indexDrop(index);
            SchemaReadCore schemaReadAfter = transaction.schemaRead().snapshot();
            Assertions.assertFalse((boolean)schemaReadBefore.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).hasNext());
            Assertions.assertFalse((boolean)schemaReadAfter.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).hasNext());
            MatcherAssert.assertThat((Object)schemaReadBefore.indexGetForName("my index"), (Matcher)Matchers.is((Object)IndexDescriptor.NO_INDEX));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldListAllIndexes() throws Exception {
        IndexDescriptor toDrop;
        IndexDescriptor toRetain2;
        IndexDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "a");
            toRetain2 = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop1}), "b");
            toDrop = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "c");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            IndexDescriptor created = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop2}), "d");
            tx.schemaWrite().indexDrop(toDrop);
            Iterable allIndexes = () -> tx.schemaRead().indexesGetAll();
            MatcherAssert.assertThat(allIndexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{toRetain, toRetain2, created}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListAllIndexesInSnapshot() throws Exception {
        IndexDescriptor toDrop;
        IndexDescriptor toRetain2;
        IndexDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "a");
            toRetain2 = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop1}), "b");
            toDrop = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "c");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor created = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop2}), "d");
            tx.schemaWrite().indexDrop(toDrop);
            SchemaReadCore after = tx.schemaRead().snapshot();
            MatcherAssert.assertThat(() -> ((SchemaReadCore)before).indexesGetAll(), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{toRetain, toRetain2, created}));
            MatcherAssert.assertThat(() -> ((SchemaReadCore)after).indexesGetAll(), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{toRetain, toRetain2, created}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByLabel() throws Exception {
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})));
            inStore = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "a");
            droppedInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "b");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            IndexDescriptor createdInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop3}), "c");
            tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop2}), "d");
            tx.schemaWrite().indexDrop(droppedInTx);
            Iterable indexes = () -> tx.schemaRead().indexesGetForLabel(this.label);
            MatcherAssert.assertThat(indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{inStore, createdInTx}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListIndexesByLabelInSnapshot() throws Exception {
        IndexDescriptor droppedInTx;
        IndexDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})));
            inStore = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "a");
            droppedInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "b");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            IndexDescriptor createdInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop3}), "c");
            tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop2}), "d");
            tx.schemaWrite().indexDrop(droppedInTx);
            Iterable indexes = () -> tx.schemaRead().snapshot().indexesGetForLabel(this.label);
            MatcherAssert.assertThat(indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{inStore, createdInTx}));
            MatcherAssert.assertThat(() -> before.indexesGetForLabel(this.label), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{inStore, createdInTx}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCreateUniquePropertyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropUniquePropertyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropConstraintByName() throws Exception {
        ConstraintDescriptor constraint;
        String constraintName = "my constraint";
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(constraintName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraintName);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreateUniqueConstraintIfExistingIndex() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("constraint name")));
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("my index")));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreateIndexIfExistingUniqueConstraint() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("constraint name"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "my index"));
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "constraint name"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropIndexIfExistingUniqueConstraint() throws Exception {
        String schemaName = "constraint name";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(schemaName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            IndexDescriptor index = transaction.schemaRead().indexGetForName(schemaName);
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropIndexBySchemaIfExistingUniqueConstraint() throws Exception {
        String schemaName = "constraint name";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(schemaName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            IndexDescriptor index = transaction.schemaRead().indexGetForName(schemaName);
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(index.schema()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToDropIndexByNameIfExistingUniqueConstraint() throws Exception {
        String schemaName = "constraint name";
        try (KernelTransaction transaction = this.beginTransaction();){
            transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName(schemaName));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().indexDrop(schemaName));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreateUniqueConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            long node1 = write.nodeCreate();
            write.nodeAddLabel(node1, this.label);
            write.nodeSetProperty(node1, this.prop1, (Value)Values.intValue((int)42));
            long node2 = write.nodeCreate();
            write.nodeAddLabel(node2, this.label);
            write.nodeSetProperty(node2, this.prop1, (Value)Values.intValue((int)42));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}))));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeUniqueConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("existing constraint"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("new constraint"));
            SchemaRead schemaRead = transaction.schemaRead();
            SchemaReadCore after = schemaRead.snapshot();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)after.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)before.constraintGetForName("existing constraint"), (Matcher)Matchers.is((Object)existing));
            MatcherAssert.assertThat((Object)after.constraintGetForName("existing constraint"), (Matcher)Matchers.is((Object)existing));
            MatcherAssert.assertThat((Object)before.constraintGetForName("new constraint"), (Matcher)Matchers.is((Object)newConstraint));
            MatcherAssert.assertThat((Object)after.constraintGetForName("new constraint"), (Matcher)Matchers.is((Object)newConstraint));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedUniqueConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldCreateNodeKeyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropNodeKeyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToNodeKeyConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            long node = write.nodeCreate();
            write.nodeAddLabel(node, this.label);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}))));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeNodeKeyConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("existing constraint"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("new constraint"));
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedNodeKeyConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("constraint name"));
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldCreateNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreatePropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            long node = write.nodeCreate();
            write.nodeAddLabel(node, this.label);
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "existing constraint");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "new constraint");
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).hasNext());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldCreateRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldDropRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (KernelTransaction transaction = this.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.beginTransaction();
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldFailToCreateRelationshipPropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (KernelTransaction transaction = this.beginTransaction();){
            Write write = transaction.dataWrite();
            write.relationshipCreate(write.nodeCreate(), this.type, write.nodeCreate());
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            Assertions.assertThrows(SchemaKernelException.class, () -> transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldSeeRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "existing constraint");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            ConstraintDescriptor newConstraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop2}), "new constraint");
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assertions.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotSeeDroppedRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (KernelTransaction transaction = this.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "constraint name");
            transaction.commit();
        }
        transaction = this.beginTransaction();
        try {
            SchemaReadCore before = transaction.schemaRead().snapshot();
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assertions.assertFalse((boolean)schemaRead.constraintExists(existing));
            Assertions.assertFalse((boolean)schemaRead.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.type, (int[])new int[]{this.prop2})).hasNext());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.snapshot().constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)before.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldListAllConstraints() throws Exception {
        ConstraintDescriptor toDrop;
        ConstraintDescriptor toRetain2;
        ConstraintDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("first constraint"));
            toRetain2 = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("second constraint"));
            toDrop = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            ConstraintDescriptor created = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "new constraint");
            tx.schemaWrite().constraintDrop(toDrop);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetAll();
            MatcherAssert.assertThat(allConstraints, (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListAllConstraintsInSnapshot() throws Exception {
        ConstraintDescriptor toDrop;
        ConstraintDescriptor toRetain2;
        ConstraintDescriptor toRetain;
        try (KernelTransaction tx = this.beginTransaction();){
            toRetain = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("first constraint"));
            toRetain2 = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("second constraint"));
            toDrop = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            ConstraintDescriptor created = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "new constraint");
            tx.schemaWrite().constraintDrop(toDrop);
            Iterable allConstraints = () -> tx.schemaRead().snapshot().constraintsGetAll();
            MatcherAssert.assertThat(allConstraints, (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created}));
            MatcherAssert.assertThat(() -> ((SchemaReadCore)before).constraintsGetAll(), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListConstraintsByLabel() throws Exception {
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        int wrongLabel;
        try (KernelTransaction tx = this.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop1})).withName("first constraint"));
            inStore = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("second constraint"));
            droppedInTx = tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2})).withName("third constraint"));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            SchemaReadCore before = tx.schemaRead().snapshot();
            ConstraintDescriptor createdInTx = tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "fourth constraint");
            tx.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)wrongLabel, (int[])new int[]{this.prop1}), "fifth constraint");
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetForLabel(this.label);
            MatcherAssert.assertThat(allConstraints, (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{inStore, createdInTx}));
            MatcherAssert.assertThat(() -> before.constraintsGetForLabel(this.label), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{inStore, createdInTx}));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void oldSnapshotShouldNotSeeNewlyCommittedIndexes() throws Exception {
        try (KernelTransaction longRunning = this.beginTransaction();){
            SchemaReadCore snapshot = longRunning.schemaRead().snapshot();
            try (KernelTransaction overlapping = this.beginTransaction();){
                overlapping.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1}), "a");
                overlapping.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.type}, (int[])new int[]{this.prop2})).withName("b"));
                overlapping.commit();
            }
            MatcherAssert.assertThat((Object)snapshot.indexGetForName("a"), (Matcher)Matchers.is((Object)IndexDescriptor.NO_INDEX));
            MatcherAssert.assertThat((Object)snapshot.indexGetForName("b"), (Matcher)Matchers.is((Object)IndexDescriptor.NO_INDEX));
            Assertions.assertFalse((boolean)snapshot.indexesGetAll().hasNext());
            Assertions.assertFalse((boolean)snapshot.index((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).hasNext());
            Assertions.assertFalse((boolean)snapshot.indexesGetForLabel(this.label).hasNext());
            Assertions.assertFalse((boolean)snapshot.indexesGetForRelationshipType(this.type).hasNext());
        }
    }

    @Test
    void oldSnapshotShouldNotSeeNewlyCommittedConstraints() throws Exception {
        try (KernelTransaction longRunning = this.beginTransaction();){
            SchemaReadCore snapshot = longRunning.schemaRead().snapshot();
            try (KernelTransaction overlapping = this.beginTransaction();){
                overlapping.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1})).withName("a"));
                overlapping.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.prop1})).withName("b"));
                overlapping.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop2}), "c");
                overlapping.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptor.forRelType((int)this.type, (int[])new int[]{this.prop1}), "d");
                overlapping.commit();
            }
            MatcherAssert.assertThat((Object)snapshot.constraintGetForName("a"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)snapshot.indexGetForName("a"), (Matcher)Matchers.is((Object)IndexDescriptor.NO_INDEX));
            MatcherAssert.assertThat((Object)snapshot.constraintGetForName("b"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)snapshot.indexGetForName("b"), (Matcher)Matchers.is((Object)IndexDescriptor.NO_INDEX));
            MatcherAssert.assertThat((Object)snapshot.constraintGetForName("c"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)snapshot.constraintGetForName("d"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assertions.assertFalse((boolean)snapshot.constraintsGetAll().hasNext());
            Assertions.assertFalse((boolean)snapshot.constraintsGetForLabel(this.label).hasNext());
            Assertions.assertFalse((boolean)snapshot.constraintsGetForRelationshipType(this.type).hasNext());
        }
    }

    @Test
    void shouldFailIndexCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1}), "my index"));
        }
    }

    @Test
    void shouldFailUniquenessConstraintCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1}))));
        }
    }

    @Test
    void shouldFailNodeKeyCreateForRepeatedProperties() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Assertions.assertThrows(SchemaKernelException.class, () -> tx.schemaWrite().nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop1, this.prop1}))));
        }
    }
}

