/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.internal.kernel.api.KernelReadTracer;

public class TestKernelReadTracer
implements KernelReadTracer {
    private final List<TraceEvent> traceEvents = new ArrayList<TraceEvent>();
    static final TraceEvent ON_ALL_NODES_SCAN = new TraceEvent(TraceEventKind.AllNodesScan);

    TestKernelReadTracer() {
    }

    public void onNode(long nodeReference) {
        this.traceEvents.add(TestKernelReadTracer.OnNode(nodeReference));
    }

    public void onAllNodesScan() {
        this.traceEvents.add(ON_ALL_NODES_SCAN);
    }

    public void onLabelScan(int label) {
        this.traceEvents.add(TestKernelReadTracer.OnLabelScan(label));
    }

    public void onIndexSeek() {
        this.traceEvents.add(TestKernelReadTracer.OnIndexSeek());
    }

    public void onRelationship(long relationshipReference) {
        this.traceEvents.add(TestKernelReadTracer.OnRelationship(relationshipReference));
    }

    public void onRelationshipGroup(int type) {
        this.traceEvents.add(TestKernelReadTracer.OnRelationshipGroup(type));
    }

    public void onProperty(int propertyKey) {
        this.traceEvents.add(TestKernelReadTracer.OnProperty(propertyKey));
    }

    void assertEvents(TraceEvent ... expected) {
        this.assertEvents(Arrays.asList(expected));
    }

    void assertEvents(List<TraceEvent> expected) {
        Assert.assertThat(this.traceEvents, (Matcher)Matchers.equalTo(expected));
        this.clear();
    }

    void clear() {
        this.traceEvents.clear();
    }

    static TraceEvent OnNode(long nodeReference) {
        return new TraceEvent(TraceEventKind.Node, nodeReference);
    }

    static TraceEvent OnLabelScan(int label) {
        return new TraceEvent(TraceEventKind.LabelScan, label);
    }

    static TraceEvent OnIndexSeek() {
        return new TraceEvent(TraceEventKind.IndexSeek, 1L);
    }

    static TraceEvent OnRelationship(long relationshipReference) {
        return new TraceEvent(TraceEventKind.Relatioship, relationshipReference);
    }

    static TraceEvent OnRelationshipGroup(int type) {
        return new TraceEvent(TraceEventKind.RelatioshipGroup, type);
    }

    static TraceEvent OnProperty(int propertyKey) {
        return new TraceEvent(TraceEventKind.Property, propertyKey);
    }

    static class TraceEvent {
        final TraceEventKind kind;
        final long hash;

        TraceEvent(TraceEventKind kind) {
            this(kind, 1L);
        }

        TraceEvent(TraceEventKind kind, long hash) {
            this.kind = kind;
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceEvent that = (TraceEvent)o;
            return this.hash == that.hash && this.kind == that.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.hash});
        }

        public String toString() {
            return String.format("%s[%d]", new Object[]{this.kind, this.hash});
        }
    }

    static enum TraceEventKind {
        Node,
        AllNodesScan,
        LabelScan,
        IndexSeek,
        Relatioship,
        RelatioshipGroup,
        Property;

    }
}

