/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralNeo4jLayoutExtension
@EphemeralPageCacheExtension
public class NeoStoresTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory dir;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private RelationshipStore relStore;
    private NodeStore nodeStore;
    private Database database;
    private KernelTransaction tx;
    private TransactionState transactionState;
    private StorageReader storageReader;
    private TokenHolder propertyKeyTokenHolder;
    private DatabaseManagementService managementService;

    @BeforeEach
    public void setUpNeoStores() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        sf.openAllNeoStores(true).close();
        this.propertyKeyTokenHolder = new DelegatingTokenHolder(this::createPropertyKeyToken, "PropertyKey");
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    private int createPropertyKeyToken(String name, boolean internal) {
        return (int)this.nextId(PropertyKeyTokenRecord.class);
    }

    @Test
    public void impossibleToGetStoreFromClosedNeoStoresContainer() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        Assertions.assertNotNull((Object)neoStores.getMetaDataStore());
        neoStores.close();
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((NeoStores)neoStores).getMetaDataStore());
        Assertions.assertEquals((Object)"Specified store was already closed.", (Object)e.getMessage());
    }

    @Test
    public void notAllowCreateDynamicStoreWithNegativeBlockSize() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[0]);){
                neoStores.createDynamicArrayStore(new File("someStore"), new File("someIdFile"), IdType.ARRAY_BLOCK, -2);
            }
        });
        Assertions.assertEquals((Object)"Block size of dynamic array store should be positive integer.", (Object)e.getMessage());
    }

    @Test
    public void impossibleToGetNotRequestedStore() {
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, NullLogProvider.getInstance());
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[]{StoreType.NODE_LABEL});){
                neoStores.getMetaDataStore();
            }
        });
        Assertions.assertEquals((Object)("Specified store was not initialized. Please specify " + StoreType.META_DATA.name() + " as one of the stores types that should be open to be able to use it."), (Object)e.getMessage());
    }

    private StorageProperty nodeAddProperty(long nodeId, int key, Object value) {
        PropertyKeyValue property = new PropertyKeyValue(key, Values.of((Object)value));
        StorageProperty oldProperty = null;
        try (StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();){
            StorageProperty fetched;
            nodeCursor.single(nodeId);
            if (nodeCursor.next() && (fetched = this.getProperty(key, nodeCursor.propertiesReference())) != null) {
                oldProperty = fetched;
            }
        }
        if (oldProperty == null) {
            this.transactionState.nodeDoAddProperty(nodeId, key, property.value());
        } else {
            this.transactionState.nodeDoChangeProperty(nodeId, key, property.value());
        }
        return property;
    }

    private StorageProperty relAddProperty(long relationshipId, int key, Object value) {
        PropertyKeyValue property = new PropertyKeyValue(key, Values.of((Object)value));
        Value oldValue = Values.NO_VALUE;
        try (StorageRelationshipScanCursor cursor = this.storageReader.allocateRelationshipScanCursor();){
            StorageProperty fetched;
            cursor.single(relationshipId);
            if (cursor.next() && (fetched = this.getProperty(key, cursor.propertiesReference())) != null) {
                oldValue = fetched.value();
            }
        }
        this.transactionState.relationshipDoReplaceProperty(relationshipId, key, oldValue, Values.of((Object)value));
        return property;
    }

    private StorageProperty getProperty(int key, long propertyId) {
        try (StoragePropertyCursor propertyCursor = this.storageReader.allocatePropertyCursor();){
            Value oldValue;
            propertyCursor.initNodeProperties(propertyId);
            if (propertyCursor.next() && (oldValue = propertyCursor.propertyValue()) != null) {
                PropertyKeyValue propertyKeyValue = new PropertyKeyValue(key, oldValue);
                return propertyKeyValue;
            }
        }
        return null;
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transactionState.relationshipTypeDoCreateForName(typeName, false, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            this.deleteRelationships(nodeIds[i]);
            this.transactionState.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
    }

    private void relDelete(long id) {
        RelationshipVisitor visitor = (relId, type, startNode, endNode) -> this.transactionState.relationshipDoDelete(relId, type, startNode, endNode);
        if (!this.transactionState.relationshipVisit(id, visitor)) {
            try (StorageRelationshipScanCursor cursor = this.storageReader.allocateRelationshipScanCursor();){
                cursor.single(id);
                if (!cursor.next()) {
                    throw new RuntimeException("Relationship " + id + " not found");
                }
                visitor.visit(id, cursor.type(), cursor.sourceNodeReference(), cursor.targetNodeReference());
            }
        }
    }

    @Test
    public void testRels2() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transactionState.relationshipTypeDoCreateForName(typeName, false, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            this.deleteRelationships(nodeIds[i]);
            this.transactionState.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.reinitializeStores(this.databaseLayout);
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transactionState.relationshipTypeDoCreateForName("relationshiptype1", false, relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transactionState.nodeDoCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transactionState.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transactionState.relationshipDoCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.relDelete(rel7);
        this.relDelete(rel4);
        this.relDelete(rel1);
        this.relDelete(rel6);
        this.relDelete(rel3);
        this.relDelete(rel2);
        this.relDelete(rel5);
        this.commitTx();
    }

    @Test
    public void setVersion() throws Exception {
        File storeDir = this.dir.homeDir();
        NeoStoresTest.createShutdownTestDatabase(this.fs, storeDir);
        Assertions.assertEquals((long)0L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)10L));
        Assertions.assertEquals((long)10L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)12L));
        Config config = Config.defaults();
        StoreFactory sf = this.getStoreFactory(config, this.databaseLayout, this.fs, LOG_PROVIDER);
        NeoStores neoStores = sf.openAllNeoStores();
        Assertions.assertEquals((long)12L, (long)neoStores.getMetaDataStore().getCurrentLogVersion());
        neoStores.close();
    }

    @Test
    public void shouldNotReadNonRecordDataAsRecord() throws Exception {
        StoreFactory factory = NeoStoresTest.newStoreFactory(this.databaseLayout, this.pageCache, this.fs);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L);
            metaDataStore.setRandomNumber(4L);
            metaDataStore.setCurrentLogVersion(5L);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0, 0L, 43L, 44L);
            metaDataStore.setStoreVersion(recordVersion);
            metaDataStore.setLatestConstraintIntroducingTx(9L);
        }
        File file = this.databaseLayout.metadataStore();
        try (StoreChannel channel = this.fs.write(file);){
            channel.position(0L);
            channel.write(ByteBuffer.wrap(UTF8.encode((String)"This is some data that is not a record.")));
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)recordVersion);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getCreationTime());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getRandomNumber());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getCurrentLogVersion());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getLastCommittedTransactionId());
            Assertions.assertEquals((long)-1L, (long)metaDataStore.getLastClosedTransactionId());
            Assertions.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assertions.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assertions.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{-1L, 44L, 43L});
        }
    }

    @Test
    public void testSetLatestConstraintTx() throws IOException {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate()), this.pageCache, this.fs, (LogProvider)LOG_PROVIDER);
        NeoStores neoStores = sf.openAllNeoStores(true);
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assertions.assertEquals((long)0L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        metaDataStore.setLatestConstraintIntroducingTx(10L);
        Assertions.assertEquals((long)10L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        neoStores.flush(IOLimiter.UNLIMITED);
        neoStores.close();
        neoStores = sf.openAllNeoStores();
        Assertions.assertEquals((long)10L, (long)neoStores.getMetaDataStore().getLatestConstraintIntroducingTx());
        neoStores.close();
    }

    @Test
    public void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        neoStores = factory.openAllNeoStores();
        try {
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            Assertions.assertEquals((long)1L, (long)lastCommittedTransactionId);
        }
        finally {
            if (neoStores != null) {
                neoStores.close();
            }
        }
    }

    @Test
    public void shouldThrowUnderlyingStorageExceptionWhenFailingToLoadStorage() {
        FileSystemAbstraction fileSystem = this.fs;
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, fileSystem, LOG_PROVIDER);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        File file = this.databaseLayout.metadataStore();
        fileSystem.deleteFile(file);
        Assertions.assertThrows(StoreNotFoundException.class, () -> {
            try (NeoStores neoStores = factory.openAllNeoStores();){
                neoStores.getMetaDataStore();
            }
        });
    }

    @Test
    public void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        MetaDataStore metaDataStore;
        StoreFactory factory = NeoStoresTest.newStoreFactory(this.databaseLayout, this.pageCache, this.fs);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore2 = neoStores.getMetaDataStore();
            metaDataStore2.setCreationTime(3L);
            metaDataStore2.setRandomNumber(4L);
            metaDataStore2.setCurrentLogVersion(5L);
            metaDataStore2.setLastCommittedAndClosedTransactionId(6L, 42, 0L, 43L, 44L);
            metaDataStore2.setStoreVersion(recordVersion);
            metaDataStore2.setLatestConstraintIntroducingTx(9L);
        }
        File file = this.databaseLayout.metadataStore();
        Assertions.assertNotEquals((long)10L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID));
        Assertions.assertNotEquals((long)11L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM));
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (long)10L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME, (long)12L);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((long)3L, (long)metaDataStore.getCreationTime());
            Assertions.assertEquals((long)4L, (long)metaDataStore.getRandomNumber());
            Assertions.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
            Assertions.assertEquals((long)6L, (long)metaDataStore.getLastCommittedTransactionId());
            Assertions.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assertions.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assertions.assertEquals((Object)new TransactionId(10L, 11, 0L), (Object)metaDataStore.getUpgradeTransaction());
            Assertions.assertEquals((long)12L, (long)metaDataStore.getUpgradeTime());
            Assertions.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{6L, 44L, 43L});
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, (long)13L);
        neoStores = factory.openAllNeoStores();
        try {
            metaDataStore = neoStores.getMetaDataStore();
            Assertions.assertEquals((Object)new TransactionId(10L, 11, 13L), (Object)metaDataStore.getUpgradeTransaction());
        }
        finally {
            if (neoStores != null) {
                neoStores.close();
            }
        }
    }

    @Test
    public void shouldSetHighestTransactionIdWhenNeeded() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444, 0L, 64L, 0L);
            store.transactionCommitted(42L, 6666, 0L);
            Assertions.assertEquals((Object)new TransactionId(42L, 6666, 0L), (Object)store.getLastCommittedTransaction());
            Assertions.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 64L});
        }
    }

    @Test
    public void shouldNotSetHighestTransactionIdWhenNeeded() {
        StoreFactory factory = this.getStoreFactory(Config.defaults(), this.databaseLayout, this.fs, LOG_PROVIDER);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444, 0L, 64L, 0L);
            store.transactionCommitted(39L, 3333, 0L);
            Assertions.assertEquals((Object)new TransactionId(40L, 4444, 0L), (Object)store.getLastCommittedTransaction());
            Assertions.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 64L});
        }
    }

    @Test
    public void shouldCloseAllTheStoreEvenIfExceptionsAreThrown() {
        Config defaults = Config.defaults((Setting)GraphDatabaseSettings.counts_store_rotation_timeout, (Object)Duration.ofMinutes(60L));
        String errorMessage = "Failing for the heck of it";
        StoreFactory factory = new StoreFactory(this.databaseLayout, defaults, (IdGeneratorFactory)new CloseFailingDefaultIdGeneratorFactory(this.fs, errorMessage), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStore = factory.openAllNeoStores(true);
        UnderlyingStorageException ex = (UnderlyingStorageException)Assertions.assertThrows(UnderlyingStorageException.class, () -> ((NeoStores)neoStore).close());
        Assertions.assertEquals((Object)errorMessage, (Object)ex.getCause().getMessage());
    }

    @Test
    public void isPresentAfterCreatingAllStores() throws Exception {
        this.fs.deleteRecursively(this.databaseLayout.databaseDirectory());
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(this.databaseLayout, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, this.fs, (LogProvider)LOG_PROVIDER);
        try (NeoStores ignore = factory.openAllNeoStores(true);){
            Assertions.assertTrue((boolean)NeoStores.isStorePresent((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (DatabaseLayout)this.databaseLayout));
        }
    }

    @Test
    public void isPresentFalseAfterCreatingAllButLastStoreType() throws Exception {
        this.fs.deleteRecursively(this.databaseLayout.databaseDirectory());
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate());
        StoreFactory factory = new StoreFactory(this.databaseLayout, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, this.fs, (LogProvider)LOG_PROVIDER);
        StoreType[] allStoreTypes = StoreType.values();
        StoreType[] allButLastStoreTypes = Arrays.copyOf(allStoreTypes, allStoreTypes.length - 1);
        try (NeoStores ignore = factory.openNeoStores(true, allButLastStoreTypes);){
            Assertions.assertFalse((boolean)NeoStores.isStorePresent((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (DatabaseLayout)this.databaseLayout));
        }
    }

    private static long defaultStoreVersion() {
        return MetaDataStore.versionStringToLong((String)RecordFormatSelector.defaultFormat().storeVersion());
    }

    private static StoreFactory newStoreFactory(DatabaseLayout databaseLayout, PageCache pageCache, FileSystemAbstraction fs) {
        RecordFormats recordFormats = RecordFormatSelector.defaultFormat();
        Config config = Config.defaults();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate());
        return new StoreFactory(databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, recordFormats, (LogProvider)LOG_PROVIDER, new OpenOption[0]);
    }

    private void reinitializeStores(DatabaseLayout databaseLayout) {
        Dependencies dependencies = new Dependencies();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        dependencies.satisfyDependency((Object)config);
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem(this.fs).setExternalDependencies((DependencyResolver)dependencies).setDatabaseRootDirectory(databaseLayout.databaseDirectory()).build();
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.managementService.database("neo4j");
        this.database = (Database)databaseAPI.getDependencyResolver().resolveDependency(Database.class);
        NeoStores neoStores = ((RecordStorageEngine)this.database.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.pStore = neoStores.getPropertyStore();
        this.rtStore = neoStores.getRelationshipTypeTokenStore();
        this.relStore = neoStores.getRelationshipStore();
        this.nodeStore = neoStores.getNodeStore();
        this.storageReader = ((StorageEngine)this.database.getDependencyResolver().resolveDependency(StorageEngine.class)).newReader();
    }

    private void startTx() throws TransactionFailureException {
        this.tx = this.database.getKernel().beginTransaction(KernelTransaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.transactionState = ((KernelTransactionImplementation)this.tx).txState();
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.commit();
    }

    private int index(String key) throws KernelException {
        return this.propertyKeyTokenHolder.getOrCreateId(key);
    }

    private long nextId(Class<?> clazz) {
        NeoStores neoStores = ((RecordStorageEngine)this.database.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStores.getPropertyKeyTokenStore().nextId();
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStores.getRelationshipTypeTokenStore().nextId();
        }
        if (clazz.equals(Node.class)) {
            return neoStores.getNodeStore().nextId();
        }
        if (clazz.equals(Relationship.class)) {
            return neoStores.getRelationshipStore().nextId();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private void validateNodeRel1(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, TokenNotFoundException {
        Assertions.assertTrue((boolean)this.nodeExists(node));
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        TransactionRecordState.PropertyReceiver<PropertyKeyValue> receiver = this.newPropertyReceiver(props);
        this.nodeLoadProperties(node, receiver);
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"string1", (Object)data.value().asObject());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)1, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)true, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        count = this.validateAndCountRelationships(node, rel1, rel2, relType1, relType2);
        Assertions.assertEquals((int)2, (int)count);
    }

    private int validateAndCountRelationships(long node, long rel1, long rel2, int relType1, int relType2) throws IOException {
        int count = 0;
        try (StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assertions.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    long rel = relationships.entityReference();
                    if (rel == rel1) {
                        Assertions.assertEquals((long)node, (long)relationships.sourceNodeReference());
                        Assertions.assertEquals((int)relType1, (int)relationships.type());
                    } else if (rel == rel2) {
                        Assertions.assertEquals((long)node, (long)relationships.targetNodeReference());
                        Assertions.assertEquals((int)relType2, (int)relationships.type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(StorageNodeCursor node) {
        StorageRelationshipTraversalCursor relationships = this.storageReader.allocateRelationshipTraversalCursor();
        relationships.init(node.entityReference(), node.allRelationshipsReference(), node.isDense());
        return relationships;
    }

    private StorageNodeCursor allocateNodeCursor(long nodeId) {
        StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();
        nodeCursor.single(nodeId);
        return nodeCursor;
    }

    private TransactionRecordState.PropertyReceiver<PropertyKeyValue> newPropertyReceiver(Map<Integer, Pair<StorageProperty, Long>> props) {
        return (property, propertyRecordId) -> props.put(property.propertyKeyId(), Pair.of((Object)property, (Object)propertyRecordId));
    }

    private void validateNodeRel2(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, RuntimeException, TokenNotFoundException {
        Assertions.assertTrue((boolean)this.nodeExists(node));
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"string2", (Object)data.value().asObject());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)2, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)false, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        count = 0;
        try (StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assertions.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    long rel = relationships.entityReference();
                    if (rel == rel1) {
                        Assertions.assertEquals((long)node, (long)relationships.targetNodeReference());
                        Assertions.assertEquals((int)relType1, (int)relationships.type());
                    } else if (rel == rel2) {
                        Assertions.assertEquals((long)node, (long)relationships.sourceNodeReference());
                        Assertions.assertEquals((int)relType2, (int)relationships.type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        Assertions.assertEquals((int)2, (int)count);
    }

    private boolean nodeExists(long nodeId) {
        try (StorageNodeCursor node = this.allocateNodeCursor(nodeId);){
            boolean bl = node.next();
            return bl;
        }
    }

    private void validateRel1(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"string1", (Object)data.value().asObject());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)1, (Object)data.value().asObject());
                this.relAddProperty(rel, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)true, (Object)data.value().asObject());
                this.relAddProperty(rel, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void assertRelationshipData(long rel, long firstNode, long secondNode, int relType) {
        try (StorageRelationshipScanCursor cursor = this.storageReader.allocateRelationshipScanCursor();){
            cursor.single(rel);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)firstNode, (long)cursor.sourceNodeReference());
            Assertions.assertEquals((long)secondNode, (long)cursor.targetNodeReference());
            Assertions.assertEquals((int)relType, (int)cursor.type());
        }
    }

    private void validateRel2(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"string2", (Object)data.value().asObject());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)2, (Object)data.value().asObject());
                this.relAddProperty(rel, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)false, (Object)data.value().asObject());
                this.relAddProperty(rel, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        NamedToken data = this.rtStore.getToken(relType1);
        Assertions.assertEquals((int)relType1, (int)data.id());
        Assertions.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assertions.assertEquals((int)relType2, (int)data.id());
        Assertions.assertEquals((Object)"relationshiptype2", (Object)data.name());
        List allData = this.rtStore.getTokens();
        Assertions.assertEquals((int)2, (int)allData.size());
        for (int i = 0; i < 2; ++i) {
            if (((NamedToken)allData.get(i)).id() == relType1) {
                Assertions.assertEquals((int)relType1, (int)((NamedToken)allData.get(i)).id());
                Assertions.assertEquals((Object)"relationshiptype1", (Object)((NamedToken)allData.get(i)).name());
                continue;
            }
            if (((NamedToken)allData.get(i)).id() == relType2) {
                Assertions.assertEquals((int)relType2, (int)((NamedToken)allData.get(i)).id());
                Assertions.assertEquals((Object)"relationshiptype2", (Object)((NamedToken)allData.get(i)).name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"-string1", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)-1, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)false, (Object)data.value().asObject());
                this.transactionState.relationshipDoRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.relLoadProperties(rel, propertyCounter);
        Assertions.assertEquals((int)3, (int)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void deleteRel2(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"-string2", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)-2, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)true, (Object)data.value().asObject());
                this.transactionState.relationshipDoRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.relLoadProperties(rel, propertyCounter);
        Assertions.assertEquals((int)3, (int)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void assertHasRelationships(long node) {
        try (StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assertions.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                Assertions.assertTrue((boolean)relationships.next());
            }
        }
    }

    private void deleteNode1(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"-string1", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)-1, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)false, (Object)data.value().asObject());
                this.transactionState.nodeDoRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.nodeLoadProperties(node, propertyCounter);
        Assertions.assertEquals((int)3, (int)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transactionState.nodeDoDelete(node);
    }

    private void deleteNode2(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)"-string2", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)-2, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assertions.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assertions.assertEquals((Object)true, (Object)data.value().asObject());
                this.transactionState.nodeDoRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assertions.assertEquals((int)3, (int)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.nodeLoadProperties(node, propertyCounter);
        Assertions.assertEquals((int)3, (int)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transactionState.nodeDoDelete(node);
    }

    private void testGetRels(long[] relIds) {
        for (long relId : relIds) {
            try (StorageRelationshipScanCursor relationship = this.storageReader.allocateRelationshipScanCursor();){
                relationship.single(relId);
                Assertions.assertFalse((boolean)relationship.next());
            }
        }
    }

    private void deleteRelationships(long nodeId) {
        try (StorageNodeCursor nodeCursor = this.allocateNodeCursor(nodeId);){
            Assertions.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    this.relDelete(relationships.entityReference());
                }
            }
        }
    }

    private static void createShutdownTestDatabase(FileSystemAbstraction fileSystem, File storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fileSystem)).impermanent().build();
        managementService.shutdown();
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver<PropertyKeyValue>> void nodeLoadProperties(long nodeId, RECEIVER receiver) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)this.nodeStore.newRecord()), RecordLoad.NORMAL);
        this.loadProperties(nodeRecord.getNextProp(), receiver);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver<PropertyKeyValue>> void relLoadProperties(long relId, RECEIVER receiver) {
        RelationshipRecord relRecord = (RelationshipRecord)this.relStore.getRecord(relId, (AbstractBaseRecord)((RelationshipRecord)this.relStore.newRecord()), RecordLoad.NORMAL);
        this.loadProperties(relRecord.getNextProp(), receiver);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver<PropertyKeyValue>> void loadProperties(long nextProp, RECEIVER receiver) {
        PropertyRecord record = this.pStore.newRecord();
        while (!Record.NULL_REFERENCE.is(nextProp)) {
            this.pStore.getRecord(nextProp, (AbstractBaseRecord)record, RecordLoad.NORMAL);
            for (PropertyBlock propBlock : record) {
                receiver.receive((StorageProperty)propBlock.newPropertyKeyValue(this.pStore), record.getId());
            }
            nextProp = record.getNextProp();
        }
    }

    private StoreFactory getStoreFactory(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, NullLogProvider logProvider) {
        return new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate()), this.pageCache, fs, (LogProvider)logProvider);
    }

    private static class CloseFailingDefaultIdGeneratorFactory
    extends DefaultIdGeneratorFactory {
        private final String errorMessage;

        CloseFailingDefaultIdGeneratorFactory(FileSystemAbstraction fs, String errorMessage) {
            super(fs, RecoveryCleanupWorkCollector.immediate());
            this.errorMessage = errorMessage;
        }

        protected IndexedIdGenerator instantiate(FileSystemAbstraction fs, PageCache pageCache, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, File fileName, LongSupplier highIdSupplier, long maxValue, IdType idType, boolean readOnly, OpenOption[] openOptions) {
            if (idType == IdType.NODE) {
                return new IndexedIdGenerator(pageCache, fileName, RecoveryCleanupWorkCollector.immediate(), idType, this.allowLargeIdCaches, () -> 42L, maxValue, readOnly, new OpenOption[0]){

                    public synchronized void close() {
                        super.close();
                        throw new IllegalStateException(errorMessage);
                    }
                };
            }
            return super.instantiate(fs, pageCache, recoveryCleanupWorkCollector, fileName, highIdSupplier, maxValue, idType, readOnly, openOptions);
        }
    }

    private static class CountingPropertyReceiver
    implements TransactionRecordState.PropertyReceiver<PropertyKeyValue> {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(PropertyKeyValue property, long propertyRecordId) {
            ++this.count;
        }
    }
}

