/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.stats;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.stats.GlobalTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class CommunityGlobalTransactionStatsIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;

    CommunityGlobalTransactionStatsIT() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).build();
        this.database = this.managementService.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        if (this.database != null) {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void useAggregatedTransactionMonitorForSystemAndDefaultDatabase() throws InterruptedException {
        ExecutorService transactionExecutor = Executors.newSingleThreadExecutor();
        DatabaseManager<?> databaseManager = this.getDatabaseManager();
        Optional defaultDatabase = databaseManager.getDatabaseContext("neo4j");
        Optional systemDatabase = databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID);
        Assertions.assertTrue((boolean)defaultDatabase.isPresent());
        Assertions.assertTrue((boolean)systemDatabase.isPresent());
        GlobalTransactionStats globalTransactionStats = (GlobalTransactionStats)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(GlobalTransactionStats.class);
        Assertions.assertEquals((long)0L, (long)globalTransactionStats.getNumberOfActiveTransactions());
        CountDownLatch startSeparateTransaction = new CountDownLatch(1);
        try {
            GraphDatabaseFacade systemFacade = ((DatabaseContext)systemDatabase.get()).databaseFacade();
            GraphDatabaseFacade defaultFacade = ((DatabaseContext)defaultDatabase.get()).databaseFacade();
            transactionExecutor.execute(() -> {
                systemFacade.beginTx();
                startSeparateTransaction.countDown();
            });
            startSeparateTransaction.await();
            Assertions.assertEquals((long)1L, (long)globalTransactionStats.getNumberOfActiveTransactions());
            try (Transaction tx = defaultFacade.beginTx();){
                TransactionCounters databaseStats = (TransactionCounters)defaultFacade.getDependencyResolver().resolveDependency(TransactionCounters.class);
                Assertions.assertEquals((long)2L, (long)globalTransactionStats.getNumberOfActiveTransactions());
                Assertions.assertEquals((long)1L, (long)databaseStats.getNumberOfActiveTransactions());
            }
        }
        finally {
            transactionExecutor.shutdown();
        }
    }

    private DatabaseManager<?> getDatabaseManager() {
        return (DatabaseManager)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(DatabaseManager.class);
    }
}

