/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TokenCreationIT {
    @Inject
    private GraphDatabaseService db;

    TokenCreationIT() {
    }

    @RepeatedTest(value=5)
    void concurrentLabelTokenCreation() throws InterruptedException {
        AtomicBoolean stop = new AtomicBoolean();
        int concurrentWorkers = 10;
        CountDownLatch latch = new CountDownLatch(concurrentWorkers);
        for (int i = 0; i < concurrentWorkers; ++i) {
            new LabelCreator(this.db, latch, stop).start();
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(500L));
        stop.set(true);
        latch.await();
    }

    private static class LabelCreator
    extends Thread {
        private final GraphDatabaseService database;
        private final CountDownLatch createLatch;
        private final AtomicBoolean stop;

        LabelCreator(GraphDatabaseService database, CountDownLatch createLatch, AtomicBoolean stop) {
            this.database = database;
            this.createLatch = createLatch;
            this.stop = stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                while (true) {
                    if (this.stop.get()) break block12;
                    try (Transaction transaction = this.database.beginTx();){
                        Label[] createdLabels = this.getLabels();
                        Node node = transaction.createNode(createdLabels);
                        Iterable nodeLabels = node.getLabels();
                        Assertions.assertEquals((Object)Iterables.asSet(Arrays.asList(createdLabels)), (Object)Iterables.asSet((Iterable)nodeLabels));
                        transaction.commit();
                    }
                    catch (Exception e) {
                        this.stop.set(true);
                        throw e;
                    }
                }
                finally {
                    this.createLatch.countDown();
                }
            }
        }

        private Label[] getLabels() {
            int randomLabelValue = ThreadLocalRandom.current().nextInt(2) + 1;
            Label[] labels = new Label[randomLabelValue];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = Label.label((String)RandomStringUtils.randomAscii((int)randomLabelValue));
            }
            return labels;
        }
    }
}

