/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NodeIndexOrderTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private final String indexName = "myIndex";

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING"})
    void shouldRangeScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "hello"));
            this.nodeWithProp(tx, "bellow");
            expected.add(this.nodeWithProp(tx, "schmello"));
            expected.add(this.nodeWithProp(tx, "low"));
            expected.add(this.nodeWithProp(tx, "trello"));
            this.nodeWithProp(tx, "yellow");
            expected.add(this.nodeWithProp(tx, "low"));
            this.nodeWithProp(tx, "below");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor();){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "now"));
                expected.add(this.nodeWithProp(tx, "jello"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.RangePredicate query = IndexQuery.range((int)prop, (String)"hello", (boolean)true, (String)"trello", (boolean)true);
                tx.dataRead().nodeIndexSeek(index, cursor, indexOrder, true, new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING"})
    void shouldPrefixScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "bee hive"));
            this.nodeWithProp(tx, "a");
            expected.add(this.nodeWithProp(tx, "become"));
            expected.add(this.nodeWithProp(tx, "be"));
            expected.add(this.nodeWithProp(tx, "bachelor"));
            this.nodeWithProp(tx, "street smart");
            expected.add(this.nodeWithProp(tx, "builder"));
            this.nodeWithProp(tx, "ceasar");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName("myIndex"));
            try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor();){
                this.nodeWithProp(tx, "allow");
                expected.add(this.nodeWithProp(tx, "bastard"));
                expected.add(this.nodeWithProp(tx, "bully"));
                this.nodeWithProp(tx, "willow");
                IndexQuery.StringPrefixPredicate query = IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"b"));
                tx.dataRead().nodeIndexSeek(index, cursor, indexOrder, true, new IndexQuery[]{query});
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertResultsInOrder(List<Pair<Long, Value>> expected, NodeValueIndexCursor cursor, IndexOrder indexOrder) {
        Comparator comparator = indexOrder == IndexOrder.ASCENDING ? (a, b) -> Values.COMPARATOR.compare((Value)a.other(), (Value)b.other()) : (a, b) -> Values.COMPARATOR.compare((Value)b.other(), (Value)a.other());
        expected.sort(comparator);
        Iterator<Pair<Long, Value>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value> expectedRow = expectedRows.next();
            MatcherAssert.assertThat((Object)cursor.nodeReference(), (Matcher)Matchers.equalTo((Object)((Long)expectedRow.first())));
            for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                Value value = cursor.propertyValue(i);
                MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)((Value)expectedRow.other())));
            }
        }
        Assertions.assertFalse((boolean)expectedRows.hasNext());
        Assertions.assertFalse((boolean)cursor.next());
    }

    private void createIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private Pair<Long, Value> nodeWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }
}

