/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TestReferenceDangling {
    @Inject
    private GraphDatabaseAPI db;

    TestReferenceDangling() {
    }

    @Test
    void testPropertyStoreReferencesOnRead() throws Throwable {
        long nId = this.ensurePropertyIsCachedLazyProperty((GraphDatabaseService)this.db, "some");
        this.restartNeoDataSource(this.db);
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(nId).getProperty("some");
            tx.commit();
        }
    }

    @Test
    void testPropertyStoreReferencesOnWrite() throws Throwable {
        long nId = this.ensurePropertyIsCachedLazyProperty((GraphDatabaseService)this.db, "some");
        this.restartNeoDataSource(this.db);
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(nId).setProperty("some", (Object)new long[]{-1L, 2L, 2L, 3L, 4L, 5L, 5L});
            tx.commit();
        }
    }

    private long ensurePropertyIsCachedLazyProperty(GraphDatabaseService slave, String key) {
        long nId;
        try (Transaction tx = slave.beginTx();){
            Node n = tx.createNode();
            nId = n.getId();
            n.setProperty(key, (Object)new long[]{-1L, 2L, 2L, 3L, 4L, 5L, 5L});
            tx.commit();
        }
        tx = slave.beginTx();
        try {
            tx.getNodeById(nId).hasProperty(key);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return nId;
    }

    private void restartNeoDataSource(GraphDatabaseAPI databaseAPI) throws Throwable {
        Database database = (Database)databaseAPI.getDependencyResolver().resolveDependency(Database.class);
        database.stop();
        database.start();
    }
}

