/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class DeleteNodeWithRelationshipsIT {
    @Inject
    private GraphDatabaseService db;

    DeleteNodeWithRelationshipsIT() {
    }

    @Test
    void shouldGiveHelpfulExceptionWhenDeletingNodeWithRelationships() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"MAYOR_OF"));
            tx.commit();
        }
        tx = this.db.beginTx();
        tx.getNodeById(node.getId()).delete();
        ConstraintViolationException ex = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ((Transaction)tx).commit());
        Assertions.assertEquals((Object)("Cannot delete node<" + node.getId() + ">, because it still has relationships. To delete this node, you must first delete its relationships."), (Object)ex.getMessage());
    }
}

