/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class GraphDatabaseInternalLogIT {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    @Inject
    private TestDirectory testDir;

    GraphDatabaseInternalLogIT() {
    }

    @Test
    void shouldWriteToInternalDiagnosticsLog() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homeDir()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs", new String[0]).toPath().toAbsolutePath()).build();
        managementService.shutdown();
        File internalLog = new File(this.testDir.directory("logs", new String[0]), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "Database neo4j is ready."));
        Assertions.assertEquals((long)2L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "Database neo4j is unavailable."));
    }

    @Test
    void shouldNotWriteDebugToInternalDiagnosticsLogByDefault() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homeDir()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs", new String[0]).toPath().toAbsolutePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        managementService.shutdown();
        File internalLog = new File(this.testDir.directory("logs", new String[0]), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
    }

    @Test
    void shouldWriteDebugToInternalDiagnosticsLogForEnabledContexts() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homeDir()).setConfig(GraphDatabaseSettings.store_internal_debug_contexts, List.of(this.getClass().getName(), "java.io")).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs", new String[0]).toPath().toAbsolutePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        logService.getInternalLog(GraphDatabaseService.class).debug("A GDS debug entry");
        logService.getInternalLog(StringWriter.class).debug("A SW debug entry");
        managementService.shutdown();
        File internalLog = new File(this.testDir.directory("logs", new String[0]), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
        Assertions.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A GDS debug entry"));
        Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A SW debug entry"));
    }

    private static long countOccurrences(File file, String substring) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath());){
            long l = lines.filter(line -> line.contains(substring)).count();
            return l;
        }
    }
}

