/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
public abstract class KernelIntegrationTest {
    @Inject
    protected TestDirectory testDir;
    protected GraphDatabaseAPI db;
    protected Kernel kernel;
    protected IndexingService indexingService;
    protected InternalTransaction transaction;
    protected KernelTransaction kernelTransaction;
    private DbmsOperations dbmsOperations;
    protected DependencyResolver dependencyResolver;
    private DatabaseManagementService managementService;

    protected TokenWrite tokenWriteInNewTransaction() {
        this.beginTransaction((LoginContext)AnonymousContext.writeToken());
        return this.kernelTransaction.tokenWrite();
    }

    protected Write dataWriteInNewTransaction() throws KernelException {
        this.beginTransaction((LoginContext)AnonymousContext.write());
        return this.kernelTransaction.dataWrite();
    }

    protected SchemaWrite schemaWriteInNewTransaction() throws KernelException {
        this.beginTransaction(LoginContext.AUTH_DISABLED);
        return this.kernelTransaction.schemaWrite();
    }

    protected Procedures procs() {
        if (this.kernelTransaction == null) {
            this.beginTransaction((LoginContext)AnonymousContext.read());
        }
        return this.kernelTransaction.procedures();
    }

    protected Procedures procsSchema() {
        if (this.kernelTransaction == null) {
            this.beginTransaction((LoginContext)AnonymousContext.full());
        }
        return this.kernelTransaction.procedures();
    }

    protected KernelTransaction newTransaction() {
        this.beginTransaction((LoginContext)AnonymousContext.read());
        return this.kernelTransaction;
    }

    protected KernelTransaction newTransaction(LoginContext loginContext) {
        this.beginTransaction(loginContext);
        return this.kernelTransaction;
    }

    protected Resource captureTransaction() {
        InternalTransaction tx = this.transaction;
        KernelTransaction ktx = this.kernelTransaction;
        return () -> {
            this.transaction = tx;
            this.kernelTransaction = ktx;
        };
    }

    protected DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    protected void commit() {
        this.transaction.commit();
        this.transaction = null;
        this.kernelTransaction = null;
    }

    protected void rollback() {
        this.transaction.rollback();
        this.transaction = null;
        this.kernelTransaction = null;
    }

    private void beginTransaction(LoginContext context) {
        this.transaction = this.db.beginTransaction(KernelTransaction.Type.implicit, context);
        this.kernelTransaction = this.transaction.kernelTransaction();
    }

    @BeforeEach
    public void setup() {
        this.startDb();
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.stopDb();
    }

    public String getDatabaseName() {
        return "neo4j";
    }

    private void startDb() {
        this.managementService = this.createDatabaseService();
        this.db = (GraphDatabaseAPI)this.managementService.database(this.getDatabaseName());
        this.dependencyResolver = this.db.getDependencyResolver();
        this.kernel = (Kernel)this.dependencyResolver.resolveDependency(Kernel.class);
        this.indexingService = (IndexingService)this.dependencyResolver.resolveDependency(IndexingService.class);
        this.dbmsOperations = (DbmsOperations)this.dependencyResolver.resolveDependency(DbmsOperations.class);
    }

    protected GraphDatabaseAPI openDatabase(String databaseName) {
        return (GraphDatabaseAPI)this.managementService.database(databaseName);
    }

    protected void shutdownDatabase(String databaseName) {
        this.managementService.shutdownDatabase(databaseName);
    }

    protected DatabaseManagementService createDatabaseService() {
        TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.configure(this.createGraphDatabaseFactory(this.testDir.homeDir())).setFileSystem(this.testDir.getFileSystem());
        return this.configure(databaseManagementServiceBuilder).build();
    }

    protected TestDatabaseManagementServiceBuilder createGraphDatabaseFactory(File databaseRootDir) {
        return new TestDatabaseManagementServiceBuilder(databaseRootDir);
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder) {
        return databaseManagementServiceBuilder;
    }

    void dbWithNoCache() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    private void stopDb() throws TransactionFailureException {
        if (this.kernelTransaction != null && this.kernelTransaction.isOpen()) {
            this.kernelTransaction.close();
        }
        this.managementService.shutdown();
    }

    protected void restartDb() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    static Value relationshipGetProperty(KernelTransaction transaction, long relationship, int property) {
        try (RelationshipScanCursor cursor = transaction.cursors().allocateRelationshipScanCursor();){
            Value value;
            block20: {
                Value value2;
                PropertyCursor properties;
                block17: {
                    Value value3;
                    block18: {
                        properties = transaction.cursors().allocatePropertyCursor();
                        transaction.dataRead().singleRelationship(relationship, cursor);
                        if (cursor.next()) break block17;
                        value3 = Values.NO_VALUE;
                        if (properties == null) break block18;
                        properties.close();
                    }
                    return value3;
                }
                try {
                    cursor.properties(properties);
                    while (properties.next()) {
                        if (properties.propertyKey() != property) continue;
                        value2 = properties.propertyValue();
                        if (properties == null) break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                {
                    block19: {
                        properties.close();
                    }
                    return value2;
                }
                value = Values.NO_VALUE;
                if (properties == null) break block20;
                properties.close();
            }
            return value;
        }
    }

    static Iterator<Long> nodeGetRelationships(KernelTransaction transaction, long node, Direction direction) {
        return KernelIntegrationTest.nodeGetRelationships(transaction, node, direction, null);
    }

    static Iterator<Long> nodeGetRelationships(KernelTransaction transaction, long node, Direction direction, int[] types) {
        try (NodeCursor cursor = transaction.cursors().allocateNodeCursor();){
            transaction.dataRead().singleNode(node, cursor);
            if (!cursor.next()) {
                Iterator<Long> iterator = Collections.emptyIterator();
                return iterator;
            }
            switch (direction) {
                case OUTGOING: {
                    ResourceIterator resourceIterator = RelationshipSelections.outgoingIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
                    return resourceIterator;
                }
                case INCOMING: {
                    ResourceIterator resourceIterator = RelationshipSelections.incomingIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
                    return resourceIterator;
                }
                case BOTH: {
                    ResourceIterator resourceIterator = RelationshipSelections.allIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
                    return resourceIterator;
                }
            }
            throw new IllegalStateException(direction + " is not a valid direction");
        }
    }

    protected static int countNodes(KernelTransaction transaction) {
        int result = 0;
        try (NodeCursor cursor = transaction.cursors().allocateNodeCursor();){
            transaction.dataRead().allNodesScan(cursor);
            while (cursor.next()) {
                ++result;
            }
        }
        return result;
    }

    public static int countRelationships(KernelTransaction transaction) {
        int result = 0;
        try (RelationshipScanCursor cursor = transaction.cursors().allocateRelationshipScanCursor();){
            transaction.dataRead().allRelationshipsScan(cursor);
            while (cursor.next()) {
                ++result;
            }
        }
        return result;
    }

    KernelImpl internalKernel() {
        return (KernelImpl)this.kernel;
    }
}

