/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.internal.batchimport.cache.idmapping.string.Workers;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.Commands;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RecordStorageEngineRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexWorkSyncTransactionApplicationStressIT {
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final RecordStorageEngineRule storageEngineRule = new RecordStorageEngineRule();
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.storageEngineRule);
    private final LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});

    @Test
    public void shouldApplyIndexUpdatesInWorkSyncedBatches() throws Exception {
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "2s"));
        int numThreads = Integer.getInteger(this.getClass().getName() + ".numThreads", Runtime.getRuntime().availableProcessors());
        DefaultFileSystemAbstraction fs = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        CollectingIndexUpdateListener index = new CollectingIndexUpdateListener();
        RecordStorageEngine storageEngine = this.storageEngineRule.getWith((FileSystemAbstraction)fs, pageCache, DatabaseLayout.ofFlat((File)this.directory.directory("neo4j", new String[0]))).indexUpdateListener((IndexUpdateListener)index).build();
        storageEngine.apply((CommandsToApply)IndexWorkSyncTransactionApplicationStressIT.tx(Collections.singletonList(Commands.createIndexRule((IndexProviderDescriptor)GenericNativeIndexProvider.DESCRIPTOR, (long)1L, (LabelSchemaDescriptor)this.descriptor))), TransactionApplicationMode.EXTERNAL);
        Workers workers = new Workers(this.getClass().getSimpleName());
        AtomicBoolean end = new AtomicBoolean();
        for (int i = 0; i < numThreads; ++i) {
            workers.start((Runnable)new Worker(i, end, storageEngine, 10, index));
        }
        Thread.sleep(duration);
        end.set(true);
        workers.awaitAndThrowOnError();
    }

    private static Value propertyValue(int id, int progress) {
        return Values.of((Object)(id + "_" + progress));
    }

    private static TransactionToApply tx(Collection<StorageCommand> commands) {
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(commands, new byte[0], -1L, -1L, -1L, -1);
        TransactionToApply tx = new TransactionToApply((TransactionRepresentation)txRepresentation);
        tx.commitment(Commitment.NO_COMMITMENT, 0L);
        return tx;
    }

    private static class CollectingIndexUpdateListener
    extends IndexUpdateListener.Adapter {
        private final ConcurrentMap<Value, Set<Long>> index = new ConcurrentHashMap<Value, Set<Long>>();

        private CollectingIndexUpdateListener() {
        }

        public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates) {
            updates.forEach(update -> {
                assert (update.updateMode() == UpdateMode.ADDED);
                this.index.computeIfAbsent(update.values()[0], value -> ConcurrentHashMap.newKeySet()).add(update.getEntityId());
            });
        }

        void assertHasIndexEntry(Value value, long entityId) {
            Assert.assertTrue((boolean)this.index.getOrDefault(value, Collections.emptySet()).contains(entityId));
        }
    }

    private static class NodeVisitor
    implements Visitor<StorageCommand, IOException> {
        long nodeId;

        private NodeVisitor() {
        }

        public boolean visit(StorageCommand element) {
            if (element instanceof Command.NodeCommand) {
                this.nodeId = ((Command.NodeCommand)element).getKey();
            }
            return false;
        }

        public NodeVisitor clear() {
            this.nodeId = -1L;
            return this;
        }
    }

    private class Worker
    implements Runnable {
        private final int id;
        private final AtomicBoolean end;
        private final RecordStorageEngine storageEngine;
        private final NodeStore nodeIds;
        private final int batchSize;
        private final CollectingIndexUpdateListener index;
        private final CommandCreationContext commandCreationContext;
        private int i;
        private int base;

        Worker(int id, AtomicBoolean end, RecordStorageEngine storageEngine, int batchSize, CollectingIndexUpdateListener index) {
            this.id = id;
            this.end = end;
            this.storageEngine = storageEngine;
            this.batchSize = batchSize;
            this.index = index;
            NeoStores neoStores = this.storageEngine.testAccessNeoStores();
            this.nodeIds = neoStores.getNodeStore();
            this.commandCreationContext = storageEngine.newCommandCreationContext();
        }

        @Override
        public void run() {
            try (RecordStorageReader reader = this.storageEngine.newReader();
                 RecordStorageCommandCreationContext creationContext = this.storageEngine.newCommandCreationContext();){
                TransactionQueue queue = new TransactionQueue(this.batchSize, (tx, last) -> {
                    this.storageEngine.apply((CommandsToApply)tx, TransactionApplicationMode.EXTERNAL);
                    this.verifyIndex(tx);
                    this.base += this.batchSize;
                });
                while (!this.end.get()) {
                    queue.queue(this.createNodeAndProperty(this.i, (StorageReader)reader, (CommandCreationContext)creationContext));
                    ++this.i;
                }
                queue.empty();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.commandCreationContext.close();
            }
        }

        private TransactionToApply createNodeAndProperty(int progress, StorageReader reader, CommandCreationContext creationContext) throws Exception {
            TxState txState = new TxState();
            long nodeId = this.nodeIds.nextId();
            txState.nodeDoCreate(nodeId);
            txState.nodeDoAddLabel((long)IndexWorkSyncTransactionApplicationStressIT.this.descriptor.getLabelId(), nodeId);
            txState.nodeDoAddProperty(nodeId, IndexWorkSyncTransactionApplicationStressIT.this.descriptor.getPropertyId(), IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, progress));
            ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
            this.storageEngine.createCommands(commands, (ReadableTransactionState)txState, reader, creationContext, null, 0L, TxStateVisitor.NO_DECORATION);
            return IndexWorkSyncTransactionApplicationStressIT.tx(commands);
        }

        private void verifyIndex(TransactionToApply tx) throws Exception {
            NodeVisitor visitor = new NodeVisitor();
            int i = 0;
            while (tx != null) {
                tx.transactionRepresentation().accept((Visitor)visitor.clear());
                Value propertyValue = IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, this.base + i);
                this.index.assertHasIndexEntry(propertyValue, visitor.nodeId);
                tx = tx.next();
                ++i;
            }
        }
    }
}

