/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.matchers.NestedThrowableMatcher;

@PageCacheExtension
@Neo4jLayoutExtension
class LogVersionUpgradeCheckerIT {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;

    LogVersionUpgradeCheckerIT() {
    }

    @Test
    void startAsNormalWhenUpgradeIsNotAllowed() {
        this.createGraphDbAndKillIt();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().setConfig(GraphDatabaseSettings.allow_upgrade, (Object)false).build();
        managementService.database("neo4j");
        managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToStartFromOlderTransactionLogsIfNotAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryVersion.V3_0_10);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().setConfig(GraphDatabaseSettings.allow_upgrade, (Object)false).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional failure = dbStateService.causeOfFailure(db.databaseId());
            Assertions.assertTrue((boolean)failure.isPresent());
            MatcherAssert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)((Throwable)failure.get())), (Matcher)new NestedThrowableMatcher(UpgradeNotAllowedException.class));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void startFromOlderTransactionLogsIfAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryVersion.V3_0_10);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        managementService.database("neo4j");
        managementService.shutdown();
    }

    private void createGraphDbAndKillIt() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"FOO")});
            tx.createNode(new Label[]{Label.label((String)"BAR")});
            tx.commit();
        }
        managementService.shutdown();
    }

    private void createStoreWithLogEntryVersion(LogEntryVersion logEntryVersion) throws Exception {
        this.createGraphDbAndKillIt();
        this.appendCheckpoint(logEntryVersion);
    }

    private void appendCheckpoint(LogEntryVersion logVersion) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache).withLogEntryReader((LogEntryReader)logEntryReader).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, new Monitors());
        LogTailScanner.LogTailInformation tailInformation = tailScanner.getTailInformation();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            FlushablePositionAwareChecksumChannel channel = logFiles.getLogFile().getWriter();
            LogPosition logPosition = tailInformation.lastCheckPoint.getLogPosition();
            channel.put(logVersion.version()).put((byte)7).putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
            channel.prepareForFlush().flush();
        }
    }
}

