/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class LogPruningIT {
    private static final SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("forced trigger");
    @Inject
    private GraphDatabaseAPI db;

    LogPruningIT() {
    }

    @Test
    void pruningStrategyShouldBeDynamic() throws IOException {
        CheckPointer checkPointer = this.getInstanceFromDb(CheckPointer.class);
        Config config = this.getInstanceFromDb(Config.class);
        FileSystemAbstraction fs = this.getInstanceFromDb(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.db.databaseLayout(), (FileSystemAbstraction)fs).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withLastCommittedTransactionIdSupplier(() -> 1L).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        this.writeTransactionsAndRotateTwice();
        checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        MatcherAssert.assertThat((Object)LogPruningIT.countTransactionLogs(logFiles), (Matcher)CoreMatchers.is((Object)3));
        config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"false", "LogPruningIT");
        checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        MatcherAssert.assertThat((Object)LogPruningIT.countTransactionLogs(logFiles), (Matcher)CoreMatchers.is((Object)2));
    }

    private void writeTransactionsAndRotateTwice() throws IOException {
        LogRotation logRotation = (LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        logRotation.rotateLogFile(LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        logRotation.rotateLogFile(LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private <T> T getInstanceFromDb(Class<T> clazz) {
        return (T)this.db.getDependencyResolver().resolveDependency(clazz);
    }

    private static int countTransactionLogs(LogFiles logFiles) {
        return logFiles.logFiles().length;
    }
}

