/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.locking;

import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.mockito.matcher.RootCauseMatcher;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

@TestDirectoryExtension
public class CommunityLockAcquisitionTimeoutIT {
    private final OtherThreadExecutor<Void> secondTransactionExecutor = new OtherThreadExecutor("transactionExecutor", null);
    private final OtherThreadExecutor<Void> clockExecutor = new OtherThreadExecutor("clockExecutor", null);
    private static final String TEST_PROPERTY_NAME = "a";
    private static final Label marker = Label.label((String)"marker");
    private static final FakeClock fakeClock = Clocks.fakeClock();
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;

    @BeforeEach
    void setUp() {
        this.managementService = this.getDbmsb(this.testDirectory).setClock((SystemNanoClock)fakeClock).setConfig(GraphDatabaseSettings.lock_acquisition_timeout, (Object)Duration.ofSeconds(2L)).build();
        this.database = this.managementService.database("neo4j");
        this.createTestNode(marker);
    }

    protected TestDatabaseManagementServiceBuilder getDbmsb(TestDirectory directory) {
        return new TestDatabaseManagementServiceBuilder(directory.homeDir());
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
        this.secondTransactionExecutor.close();
        this.clockExecutor.close();
    }

    @Test
    void timeoutOnAcquiringExclusiveLock() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                ResourceIterator nodes = tx.findNodes(marker);
                Node node = (Node)nodes.next();
                node.setProperty(TEST_PROPERTY_NAME, (Object)"b");
                Future propertySetFuture = this.secondTransactionExecutor.executeDontWait(state -> {
                    try (Transaction transaction1 = this.database.beginTx();){
                        transaction1.getNodeById(node.getId()).setProperty(TEST_PROPERTY_NAME, (Object)"b");
                        transaction1.commit();
                    }
                    return null;
                });
                this.secondTransactionExecutor.waitUntilWaiting(this.exclusiveLockWaitingPredicate());
                this.clockExecutor.execute(state -> {
                    fakeClock.forward(3L, TimeUnit.SECONDS);
                    return null;
                });
                propertySetFuture.get();
            }
        });
        MatcherAssert.assertThat((Object)e, (Matcher)new RootCauseMatcher(LockAcquisitionTimeoutException.class, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Unable to acquire lock within configured timeout (dbms.lock.acquisition.timeout). Unable to acquire lock for resource: NODE with id: 0 within 2000 millis."));
    }

    @Test
    void timeoutOnAcquiringSharedLock() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                Locks lockManger = this.getLockManager();
                lockManger.newClient().acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{1L});
                Future propertySetFuture = this.secondTransactionExecutor.executeDontWait(state -> {
                    try (Transaction nestedTransaction = this.database.beginTx();){
                        ResourceIterator nodes = nestedTransaction.findNodes(marker);
                        Node node = (Node)nodes.next();
                        node.addLabel(Label.label((String)"anotherLabel"));
                        nestedTransaction.commit();
                    }
                    return null;
                });
                this.secondTransactionExecutor.waitUntilWaiting(this.sharedLockWaitingPredicate());
                this.clockExecutor.execute(state -> {
                    fakeClock.forward(3L, TimeUnit.SECONDS);
                    return null;
                });
                propertySetFuture.get();
            }
        });
        MatcherAssert.assertThat((Object)e, (Matcher)new RootCauseMatcher(LockAcquisitionTimeoutException.class, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Unable to acquire lock within configured timeout (dbms.lock.acquisition.timeout). Unable to acquire lock for resource: LABEL with id: 1 within 2000 millis."));
    }

    protected Locks getLockManager() {
        return (Locks)this.getDependencyResolver().resolveDependency(CommunityLockManger.class);
    }

    protected DependencyResolver getDependencyResolver() {
        return ((GraphDatabaseAPI)this.database).getDependencyResolver();
    }

    protected Predicate<OtherThreadExecutor.WaitDetails> exclusiveLockWaitingPredicate() {
        return waitDetails -> waitDetails.isAt(CommunityLockClient.class, "acquireExclusive");
    }

    protected Predicate<OtherThreadExecutor.WaitDetails> sharedLockWaitingPredicate() {
        return waitDetails -> waitDetails.isAt(CommunityLockClient.class, "acquireShared");
    }

    private void createTestNode(Label marker) {
        try (Transaction transaction = this.database.beginTx();){
            transaction.createNode(new Label[]{marker});
            transaction.commit();
        }
    }
}

