/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class CountsStoreRecoveryTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    CountsStoreRecoveryTest() {
    }

    @BeforeEach
    void before() {
        this.managementService = CountsStoreRecoveryTest.databaseFactory((FileSystemAbstraction)this.fs).impermanent().build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldRecoverTheCountsStoreEvenWhenIfNeoStoreDoesNotNeedRecovery() throws Exception {
        this.createNode("A");
        this.checkPoint();
        this.createNode("B");
        this.flushNeoStoreOnly();
        this.crashAndRestart();
        Kernel kernel = (Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            Assertions.assertEquals((long)1L, (long)tx.dataRead().countsForNode(tx.tokenRead().nodeLabel("A")));
            Assertions.assertEquals((long)1L, (long)tx.dataRead().countsForNode(tx.tokenRead().nodeLabel("B")));
            Assertions.assertEquals((long)2L, (long)tx.dataRead().countsForNode(-1));
        }
    }

    private void flushNeoStoreOnly() {
        NeoStores neoStores = ((RecordStorageEngine)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        metaDataStore.flush();
    }

    private void checkPoint() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void crashAndRestart() throws Exception {
        EphemeralFileSystemAbstraction uncleanFs = this.fs.snapshot();
        try {
            this.managementService.shutdown();
        }
        finally {
            this.fs.close();
            this.fs = uncleanFs;
        }
        this.managementService = CountsStoreRecoveryTest.databaseFactory((FileSystemAbstraction)uncleanFs).impermanent().build();
        this.db = this.managementService.database("neo4j");
    }

    private void createNode(String label) {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)label)});
            tx.commit();
        }
    }

    private static TestDatabaseManagementServiceBuilder databaseFactory(FileSystemAbstraction fs) {
        return new TestDatabaseManagementServiceBuilder().setFileSystem(fs);
    }
}

