/*
 * Decompiled with CFR 0.152.
 */
package migration;

import java.io.File;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.DateValue;

@TestDirectoryExtension
class TemporalPropertiesRecordFormatIT {
    @Inject
    private TestDirectory testDirectory;

    TemporalPropertiesRecordFormatIT() {
    }

    @Test
    void createDatePropertyOnLatestDatabase() {
        File storeDir = this.testDirectory.homeDir();
        Label label = Label.label((String)"DateNode");
        String propertyKey = "a";
        LocalDate date = (LocalDate)DateValue.date((int)1991, (int)5, (int)3).asObjectCopy();
        DatabaseManagementService managementService = TemporalPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService database = TemporalPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty(propertyKey, (Object)date);
            transaction.commit();
        }
        managementService.shutdown();
        managementService = TemporalPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService restartedDatabase = TemporalPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = restartedDatabase.beginTx();){
            Assertions.assertNotNull((Object)transaction.findNode(label, propertyKey, (Object)date));
        }
        managementService.shutdown();
    }

    @Test
    void createDateArrayOnLatestDatabase() {
        File storeDir = this.testDirectory.homeDir();
        Label label = Label.label((String)"DateNode");
        String propertyKey = "a";
        LocalDate date = (LocalDate)DateValue.date((int)1991, (int)5, (int)3).asObjectCopy();
        DatabaseManagementService managementService = TemporalPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService database = TemporalPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty(propertyKey, (Object)new LocalDate[]{date, date});
            transaction.commit();
        }
        managementService.shutdown();
        managementService = TemporalPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService restartedDatabase = TemporalPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = restartedDatabase.beginTx();
             ResourceIterator nodes = transaction.findNodes(label);){
            Node node = (Node)nodes.next();
            LocalDate[] points = (LocalDate[])node.getProperty(propertyKey);
            MatcherAssert.assertThat((Object)points, (Matcher)Matchers.arrayWithSize((int)2));
        }
        managementService.shutdown();
    }

    private static DatabaseManagementService startDatabaseService(File storeDir) {
        return new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.record_format, (Object)"standard").build();
    }

    private static GraphDatabaseService getDefaultDatabase(DatabaseManagementService managementService) {
        return managementService.database("neo4j");
    }
}

