/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.test.rule.ImpermanentDbmsRule;

@RunWith(value=Parameterized.class)
public class IndexingCompositeQueryAcceptanceTest {
    @ClassRule
    public static ImpermanentDbmsRule dbRule = new ImpermanentDbmsRule();
    @Rule
    public final TestName testName = new TestName();
    @Parameterized.Parameter(value=0)
    public String[] keys;
    @Parameterized.Parameter(value=1)
    public Object[] values;
    @Parameterized.Parameter(value=2)
    public Object[][] nonMatching;
    @Parameterized.Parameter(value=3)
    public IndexSeek indexSeek;
    @Parameterized.Parameter(value=4)
    public boolean withIndex;
    private static final Label LABEL = Label.label((String)"LABEL1");
    private GraphDatabaseService db;
    private static final IndexSeek biIndexSeek = (keys, values, db, tx) -> {
        assert (keys.length == 2);
        assert (values.length == 2);
        return tx.findNodes(LABEL, keys[0], values[0], keys[1], values[1]);
    };
    private static final IndexSeek triIndexSeek = (keys, values, db, tx) -> {
        assert (keys.length == 3);
        assert (values.length == 3);
        return tx.findNodes(LABEL, keys[0], values[0], keys[1], values[1], keys[2], values[2]);
    };
    private static final IndexSeek mapIndexSeek = (keys, values, db, tx) -> tx.findNodes(LABEL, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, values));

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList(IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek, false), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, true), IndexingCompositeQueryAcceptanceTest.testCase((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek, false));
    }

    @Before
    public void setup() {
        this.db = dbRule.getGraphDatabaseAPI();
        if (this.withIndex) {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(LABEL).on(this.keys[0]).create();
                IndexCreator indexCreator = tx.schema().indexFor(LABEL);
                for (String key : this.keys) {
                    indexCreator = indexCreator.on(key);
                }
                indexCreator.create();
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    @After
    public void tearDown() {
        dbRule.shutdown();
    }

    @Test
    public void shouldSupportIndexSeek() {
        this.createNodes(this.db, LABEL, this.nonMatching);
        MutableLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes((MutableLongSet)found, this.indexSeek.findNodes(this.keys, this.values, this.db, tx));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldSupportIndexSeekBackwardsOrder() {
        this.createNodes(this.db, LABEL, this.nonMatching);
        MutableLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        LongHashSet found = new LongHashSet();
        String[] reversedKeys = new String[this.keys.length];
        Object[] reversedValues = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            reversedValues[this.keys.length - 1 - i] = this.values[i];
            reversedKeys[this.keys.length - 1 - i] = this.keys[i];
        }
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes((MutableLongSet)found, this.indexSeek.findNodes(reversedKeys, reversedValues, this.db, tx));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldIncludeNodesCreatedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, this.nonMatching[0], this.nonMatching[1]);
        MutableLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            expected.add(this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, this.values), LABEL).getId());
            this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, this.nonMatching[2]), LABEL);
            this.collectNodes((MutableLongSet)found, this.indexSeek.findNodes(this.keys, this.values, this.db, tx));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldNotIncludeNodesDeletedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[0]});
        MutableLongSet toDelete = this.createNodes(this.db, LABEL, this.values, this.nonMatching[1], this.nonMatching[2]);
        MutableLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator deleting = toDelete.longIterator();
            while (deleting.hasNext()) {
                long id = deleting.next();
                tx.getNodeById(id).delete();
                expected.remove(id);
            }
            this.collectNodes((MutableLongSet)found, this.indexSeek.findNodes(this.keys, this.values, this.db, tx));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldConsiderNodesChangedInSameTxInIndexSeek() {
        this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[0]});
        MutableLongSet toChangeToMatch = this.createNodes(this.db, LABEL, new Object[][]{this.nonMatching[1]});
        MutableLongSet toChangeToNotMatch = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        MutableLongSet expected = this.createNodes(this.db, LABEL, new Object[][]{this.values});
        LongHashSet found = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            LongIterator toMatching = toChangeToMatch.longIterator();
            while (toMatching.hasNext()) {
                long id = toMatching.next();
                this.setProperties(tx, id, this.values);
                expected.add(id);
            }
            LongIterator toNotMatching = toChangeToNotMatch.longIterator();
            while (toNotMatching.hasNext()) {
                long id = toNotMatching.next();
                this.setProperties(tx, id, this.nonMatching[2]);
                expected.remove(id);
            }
            this.collectNodes((MutableLongSet)found, this.indexSeek.findNodes(this.keys, this.values, this.db, tx));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    private MutableLongSet createNodes(GraphDatabaseService db, Label label, Object[] ... propertyValueTuples) {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            for (Object[] valueTuple : propertyValueTuples) {
                expected.add(this.createNode(tx, IndexingCompositeQueryAcceptanceTest.propertyMap(this.keys, valueTuple), label).getId());
            }
            tx.commit();
        }
        return expected;
    }

    private static Map<String, Object> propertyMap(String[] keys, Object[] valueTuple) {
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            propertyValues.put(keys[i], valueTuple[i]);
        }
        return propertyValues;
    }

    private void collectNodes(MutableLongSet bucket, ResourceIterator<Node> toCollect) {
        while (toCollect.hasNext()) {
            bucket.add(((Node)toCollect.next()).getId());
        }
    }

    public Node createNode(Transaction transaction, Map<String, Object> properties, Label ... labels) {
        Node node = transaction.createNode(labels);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            node.setProperty(property.getKey(), property.getValue());
        }
        return node;
    }

    private static Object[] testCase(Integer[] values, IndexSeek indexSeek, boolean withIndex) {
        Object[][] nonMatching = new Object[][]{IndexingCompositeQueryAcceptanceTest.plus(values, 1), IndexingCompositeQueryAcceptanceTest.plus(values, 2), IndexingCompositeQueryAcceptanceTest.plus(values, 3)};
        String[] keys = (String[])Arrays.stream(values).map(v -> "key" + v).toArray(String[]::new);
        return new Object[]{keys, values, nonMatching, indexSeek, withIndex};
    }

    private static <T> Object[] plus(Integer[] values, int offset) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] + offset;
        }
        return result;
    }

    private void setProperties(Transaction tx, long id, Object[] values) {
        Node node = tx.getNodeById(id);
        for (int i = 0; i < this.keys.length; ++i) {
            node.setProperty(this.keys[i], values[i]);
        }
    }

    private static interface IndexSeek {
        public ResourceIterator<Node> findNodes(String[] var1, Object[] var2, GraphDatabaseService var3, Transaction var4);
    }
}

