/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.LabelScanWriter;
import org.neo4j.internal.index.label.NativeLabelScanStoreTest;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class NativeLabelScanStoreStartupIT {
    private static final Label LABEL = Label.label((String)"testLabel");
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private RandomRule random;
    private int labelId;

    NativeLabelScanStoreStartupIT() {
    }

    @Test
    void scanStoreStartWithoutExistentIndex() throws Throwable {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        RecoveryCleanupWorkCollector workCollector = this.getGroupingRecoveryCleanupWorkCollector();
        labelScanStore.shutdown();
        workCollector.shutdown();
        NativeLabelScanStoreStartupIT.deleteLabelScanStoreFiles(this.databaseAPI.databaseLayout());
        workCollector.init();
        labelScanStore.init();
        workCollector.start();
        labelScanStore.start();
        NativeLabelScanStoreStartupIT.checkLabelScanStoreAccessible(labelScanStore);
    }

    @Test
    void scanStoreRecreateCorruptedIndexOnStartup() throws Throwable {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        RecoveryCleanupWorkCollector workCollector = this.getGroupingRecoveryCleanupWorkCollector();
        this.createTestNode();
        long[] labels = this.readNodesForLabel(labelScanStore);
        Assertions.assertEquals((int)1, (int)labels.length, (String)"Label scan store see 1 label for node");
        labelScanStore.force(IOLimiter.UNLIMITED);
        labelScanStore.shutdown();
        workCollector.shutdown();
        this.corruptLabelScanStoreFiles(this.databaseAPI.databaseLayout());
        workCollector.init();
        labelScanStore.init();
        workCollector.start();
        labelScanStore.start();
        long[] rebuildLabels = this.readNodesForLabel(labelScanStore);
        Assertions.assertArrayEquals((long[])labels, (long[])rebuildLabels, (String)"Store should rebuild corrupted index");
    }

    private LabelScanStore getLabelScanStore() {
        return this.getDependency(LabelScanStore.class);
    }

    private RecoveryCleanupWorkCollector getGroupingRecoveryCleanupWorkCollector() {
        return (RecoveryCleanupWorkCollector)this.databaseAPI.getDependencyResolver().resolveDependency(RecoveryCleanupWorkCollector.class);
    }

    private <T> T getDependency(Class<T> clazz) {
        return (T)this.databaseAPI.getDependencyResolver().resolveDependency(clazz);
    }

    private long[] readNodesForLabel(LabelScanStore labelScanStore) {
        return PrimitiveLongCollections.closingAsArray((PrimitiveLongResourceIterator)labelScanStore.newReader().nodesWithLabel(this.labelId));
    }

    private void createTestNode() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{LABEL});
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            this.labelId = ktx.tokenRead().nodeLabel(LABEL.name());
            transaction.commit();
        }
    }

    private void scrambleFile(File file) throws IOException {
        NativeLabelScanStoreTest.scrambleFile((Random)this.random.random(), (File)file);
    }

    private static File storeFile(DatabaseLayout databaseLayout) {
        return databaseLayout.labelScanStore();
    }

    private void corruptLabelScanStoreFiles(DatabaseLayout databaseLayout) throws IOException {
        this.scrambleFile(NativeLabelScanStoreStartupIT.storeFile(databaseLayout));
    }

    private static void deleteLabelScanStoreFiles(DatabaseLayout databaseLayout) {
        Assertions.assertTrue((boolean)NativeLabelScanStoreStartupIT.storeFile(databaseLayout).delete());
    }

    private static void checkLabelScanStoreAccessible(LabelScanStore labelScanStore) throws IOException {
        int labelId = 1;
        try (LabelScanWriter labelScanWriter = labelScanStore.newWriter();){
            labelScanWriter.write(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{labelId}));
        }
        LabelScanReader labelScanReader = labelScanStore.newReader();
        try (PrimitiveLongResourceIterator iterator = labelScanReader.nodesWithLabel(labelId);){
            Assertions.assertEquals((long)1L, (long)iterator.next());
        }
    }
}

