/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class NativeLabelScanStoreUpdateIT {
    @Inject
    private GraphDatabaseService db;
    private Label First;
    private Label Second;
    private Label Third;

    NativeLabelScanStoreUpdateIT() {
    }

    @BeforeEach
    void setupLabels() {
        this.First = Label.label((String)"First");
        this.Second = Label.label((String)"Second");
        this.Third = Label.label((String)"Third");
    }

    @Test
    void shouldGetNodesWithCreatedLabel() {
        Node node1 = this.createLabeledNode(this.First);
        Node node2 = this.createLabeledNode(this.Second);
        Node node3 = this.createLabeledNode(this.Third);
        Node node4 = this.createLabeledNode(this.First, this.Second, this.Third);
        Node node5 = this.createLabeledNode(this.First, this.Third);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.First)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2, node4}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.Second)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node3, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.Third)));
    }

    @Test
    void shouldGetNodesWithAddedLabel() {
        Node node1 = this.createLabeledNode(this.First);
        Node node2 = this.createLabeledNode(this.Second);
        Node node3 = this.createLabeledNode(this.Third);
        Node node4 = this.createLabeledNode(this.First);
        Node node5 = this.createLabeledNode(this.First);
        this.addLabels(node4, this.Second, this.Third);
        this.addLabels(node5, this.Third);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.First)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2, node4}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.Second)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node3, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(this.Third)));
    }

    @Test
    void shouldGetNodesAfterDeletedNodes() {
        Node node1 = this.createLabeledNode(this.First, this.Second);
        Node node2 = this.createLabeledNode(this.First, this.Third);
        this.deleteNode(node1);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(this.First));
        Assertions.assertEquals(Collections.emptySet(), this.getAllNodesWithLabel(this.Second));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(this.Third));
    }

    @Test
    void shouldGetNodesAfterRemovedLabels() {
        Node node1 = this.createLabeledNode(this.First, this.Second);
        Node node2 = this.createLabeledNode(this.First, this.Third);
        this.removeLabels(node1, this.First);
        this.removeLabels(node2, this.Third);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(this.First));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1}), this.getAllNodesWithLabel(this.Second));
        Assertions.assertEquals(Collections.emptySet(), this.getAllNodesWithLabel(this.Third));
    }

    @Test
    void retrieveNodeIdsInAscendingOrder() {
        for (int i = 0; i < 50; ++i) {
            this.createLabeledNode(Labels.First, Labels.Second);
            this.createLabeledNode(Labels.Second);
            this.createLabeledNode(Labels.First);
        }
        long nodeWithThirdLabel = this.createLabeledNode(Labels.Third).getId();
        this.verifyFoundNodes(Labels.Third, "Expect to see 1 matched nodeId: " + nodeWithThirdLabel, nodeWithThirdLabel);
        Node nodeById = this.getNodeById(1L);
        this.addLabels(nodeById, Labels.Third);
        this.verifyFoundNodes(Labels.Third, "Expect to see 2 matched nodeIds: 1, " + nodeWithThirdLabel, 1L, nodeWithThirdLabel);
    }

    @Test
    void shouldHandleLargeAmountsOfNodesAddedAndRemovedInSameTx() {
        int l;
        Node node;
        int labelsToAdd = 80;
        int labelsToRemove = 40;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            for (l = 0; l < labelsToAdd; ++l) {
                node.addLabel(Label.label((String)("Label-" + l)));
            }
            for (l = 0; l < labelsToRemove; ++l) {
                node.removeLabel(Label.label((String)("Label-" + l)));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (l = labelsToAdd - 1; l >= labelsToRemove; --l) {
                Label label = Label.label((String)("Label-" + l));
                MatcherAssert.assertThat((String)("Should have found node when looking for label " + label), (Object)((Node)Iterators.single((Iterator)tx.findNodes(label))), (Matcher)CoreMatchers.equalTo((Object)node));
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void verifyFoundNodes(Label label, String sizeMismatchMessage, long ... expectedNodeIds) {
        try (Transaction tx = this.db.beginTx();){
            ResourceIterator nodes = tx.findNodes(label);
            List nodeList = Iterators.asList((Iterator)nodes);
            MatcherAssert.assertThat((String)sizeMismatchMessage, (Object)nodeList, (Matcher)Matchers.hasSize((int)expectedNodeIds.length));
            int index = 0;
            for (Node node : nodeList) {
                Assertions.assertEquals((long)expectedNodeIds[index++], (long)node.getId());
            }
        }
    }

    private void removeLabels(Node node, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node nodeById = tx.getNodeById(node.getId());
            for (Label label : labels) {
                nodeById.removeLabel(label);
            }
            tx.commit();
        }
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.db.beginTx();){
            Set set = Iterators.asSet((Iterator)tx.findNodes(label));
            return set;
        }
    }

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(labels);
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private void addLabels(Node node, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            node = tx.getNodeById(node.getId());
            for (Label label : labels) {
                node.addLabel(label);
            }
            tx.commit();
        }
    }

    private Node getNodeById(long id) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.getNodeById(id);
            return node;
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

