/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Consumer;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public enum RelationshipFacadeMethods implements Consumer<Relationship>
{
    HAS_PROPERTY((FacadeMethod<Relationship>)new FacadeMethod("boolean hasProperty( String key )", r -> r.hasProperty("foo"))),
    GET_PROPERTY((FacadeMethod<Relationship>)new FacadeMethod("Object getProperty( String key )", r -> r.getProperty("foo"))),
    GET_PROPERTY_WITH_DEFAULT((FacadeMethod<Relationship>)new FacadeMethod("Object getProperty( String key, Object defaultValue )", r -> r.getProperty("foo", (Object)42))),
    SET_PROPERTY((FacadeMethod<Relationship>)new FacadeMethod("void setProperty( String key, Object value )", r -> r.setProperty("foo", (Object)42))),
    REMOVE_PROPERTY((FacadeMethod<Relationship>)new FacadeMethod("Object removeProperty( String key )", r -> r.removeProperty("foo"))),
    GET_PROPERTY_KEYS((FacadeMethod<Relationship>)new FacadeMethod("Iterable<String> getPropertyKeys()", r -> FacadeMethod.consume((Iterable)r.getPropertyKeys()))),
    DELETE((FacadeMethod<Relationship>)new FacadeMethod("void delete()", Relationship::delete)),
    GET_START_NODE((FacadeMethod<Relationship>)new FacadeMethod("Node getStartNode()", Relationship::getStartNode)),
    GET_END_NODE((FacadeMethod<Relationship>)new FacadeMethod("Node getEndNode()", Relationship::getEndNode)),
    GET_OTHER_NODE((FacadeMethod<Relationship>)new FacadeMethod("Node getOtherNode( Node node )", r -> r.getOtherNode(null))),
    GET_NODES((FacadeMethod<Relationship>)new FacadeMethod("Node[] getNodes()", Relationship::getNodes)),
    GET_TYPE((FacadeMethod<Relationship>)new FacadeMethod("RelationshipType getType()", Relationship::getType)),
    IS_TYPE((FacadeMethod<Relationship>)new FacadeMethod("boolean isType( RelationshipType type )", r -> r.isType(RelationshipType.withName((String)"foo"))));

    private final FacadeMethod<Relationship> facadeMethod;

    private RelationshipFacadeMethods(FacadeMethod<Relationship> facadeMethod) {
        this.facadeMethod = facadeMethod;
    }

    @Override
    public void accept(Relationship relationship) {
        this.facadeMethod.accept((Object)relationship);
    }

    public String toString() {
        return this.facadeMethod.toString();
    }
}

