/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class RestartIT {
    @Inject
    private TestDirectory testDir;

    RestartIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToReadExistingStoreOnRestart() throws IOException {
        this.testDir.cleanup();
        File storeDir = this.testDir.absolutePath();
        DatabaseManagementService oldManagementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        oldManagementService.shutdown();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            MatcherAssert.assertThat((Object)tx.getAllNodes(), (Matcher)Matchers.emptyIterable());
        }
        finally {
            managementService.shutdown();
        }
    }
}

