/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.id.BufferedIdController;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class CommunityEditionModuleIntegrationTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;

    CommunityEditionModuleIntegrationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void createBufferedIdComponentsByDefault() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            IdController idController = (IdController)dependencyResolver.resolveDependency(IdController.class);
            IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class);
            MatcherAssert.assertThat((Object)idController, (Matcher)Matchers.instanceOf(BufferedIdController.class));
            MatcherAssert.assertThat((Object)idGeneratorFactory, (Matcher)Matchers.instanceOf(BufferingIdGeneratorFactory.class));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void fileWatcherFileNameFilter() {
        Predicate filter = CommunityEditionModule.communityFileWatcherFileNameFilter();
        Assertions.assertFalse((boolean)filter.test(this.databaseLayout.metadataStore().getName()));
        Assertions.assertFalse((boolean)filter.test(this.databaseLayout.nodeStore().getName()));
        Assertions.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
    }
}

