/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionTestBase;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionIterator;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;

public abstract class RelationshipSparseSelectionTestBase<Traverser extends RelationshipSparseSelection>
extends RelationshipSelectionTestBase {
    private StubRelationshipCursor innerByGroup = new StubRelationshipCursor(new TestRelationshipChain(42L).outgoing(0L, 10L, 100).incoming(1L, 11L, 100).loop(2L, 100).outgoing(3L, 20L, 101).incoming(4L, 21L, 101).loop(5L, 101).outgoing(6L, 30L, 102).incoming(7L, 31L, 102).loop(8L, 102));
    private StubRelationshipCursor innerByDir = new StubRelationshipCursor(new TestRelationshipChain(42L).outgoing(1L, 10L, 100).outgoing(2L, 11L, 101).outgoing(3L, 12L, 102).incoming(4L, 20L, 100).incoming(5L, 21L, 101).incoming(6L, 22L, 102).loop(7L, 100).loop(8L, 101).loop(9L, 102));

    @BeforeEach
    public void rewindInner() {
        this.innerByDir.rewind();
        this.innerByGroup.rewind();
    }

    protected abstract Traverser make();

    @Test
    void shouldSelectOutgoing() {
        Traverser traverser = this.make();
        traverser.outgoing((RelationshipTraversalCursor)this.innerByGroup);
        this.assertOutgoing(traverser, 10, 100);
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 20, 101);
        this.assertLoop(traverser, 101);
        this.assertOutgoing(traverser, 30, 102);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByGroup);
    }

    @Test
    void shouldSelectIncoming() {
        Traverser traverser = this.make();
        traverser.incoming((RelationshipTraversalCursor)this.innerByGroup);
        this.assertIncoming(traverser, 11, 100);
        this.assertLoop(traverser, 100);
        this.assertIncoming(traverser, 21, 101);
        this.assertLoop(traverser, 101);
        this.assertIncoming(traverser, 31, 102);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByGroup);
    }

    @Test
    void shouldSelectAll() {
        Traverser traverser = this.make();
        traverser.all((RelationshipTraversalCursor)this.innerByGroup);
        this.assertOutgoing(traverser, 10, 100);
        this.assertIncoming(traverser, 11, 100);
        this.assertLoop(traverser, 100);
        this.assertOutgoing(traverser, 20, 101);
        this.assertIncoming(traverser, 21, 101);
        this.assertLoop(traverser, 101);
        this.assertOutgoing(traverser, 30, 102);
        this.assertIncoming(traverser, 31, 102);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByGroup);
    }

    @Test
    void shouldSelectOutgoingOfType() {
        Traverser traverser = this.make();
        traverser.outgoing((RelationshipTraversalCursor)this.innerByDir, this.types(100, 102));
        this.assertOutgoing(traverser, 10, 100);
        this.assertOutgoing(traverser, 12, 102);
        this.assertLoop(traverser, 100);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByDir);
    }

    @Test
    void shouldSelectIncomingOfType() {
        Traverser traverser = this.make();
        traverser.incoming((RelationshipTraversalCursor)this.innerByDir, this.types(100, 102));
        this.assertIncoming(traverser, 20, 100);
        this.assertIncoming(traverser, 22, 102);
        this.assertLoop(traverser, 100);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByDir);
    }

    @Test
    void shouldSelectAllOfType() {
        Traverser traverser = this.make();
        traverser.all((RelationshipTraversalCursor)this.innerByDir, this.types(100, 102));
        this.assertOutgoing(traverser, 10, 100);
        this.assertOutgoing(traverser, 12, 102);
        this.assertIncoming(traverser, 20, 100);
        this.assertIncoming(traverser, 22, 102);
        this.assertLoop(traverser, 100);
        this.assertLoop(traverser, 102);
        this.assertEmptyAndClosed(traverser, (RelationshipTraversalCursor)this.innerByDir);
    }

    abstract void assertOutgoing(Traverser var1, int var2, int var3);

    abstract void assertIncoming(Traverser var1, int var2, int var3);

    abstract void assertLoop(Traverser var1, int var2);

    abstract void assertEmpty(Traverser var1);

    private void assertEmptyAndClosed(Traverser traverser, RelationshipTraversalCursor inner) {
        this.assertEmpty(traverser);
        Assertions.assertTrue((boolean)inner.isClosed(), (String)"closed traversal cursor");
    }

    public static class CursorTest
    extends RelationshipSparseSelectionTestBase<RelationshipSparseSelectionCursor> {
        @Override
        protected RelationshipSparseSelectionCursor make() {
            return new RelationshipSparseSelectionCursor();
        }

        @Override
        void assertOutgoing(RelationshipSparseSelectionCursor iterator, int targetNode, int type) {
            this.assertOutgoing(iterator, targetNode, type);
        }

        @Override
        void assertIncoming(RelationshipSparseSelectionCursor iterator, int sourceNode, int type) {
            this.assertIncoming(iterator, sourceNode, type);
        }

        @Override
        void assertLoop(RelationshipSparseSelectionCursor iterator, int type) {
            this.assertLoop(iterator, type);
        }

        @Override
        void assertEmpty(RelationshipSparseSelectionCursor iterator) {
            this.assertEmpty(iterator);
        }
    }

    public static class IteratorTest
    extends RelationshipSparseSelectionTestBase<RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R>> {
        @Override
        protected RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R> make() {
            return new RelationshipSparseSelectionIterator(RelationshipSelectionTestBase.R::new);
        }

        @Override
        void assertOutgoing(RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int targetNode, int type) {
            this.assertOutgoing(iterator, targetNode, type);
        }

        @Override
        void assertIncoming(RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int sourceNode, int type) {
            this.assertIncoming(iterator, sourceNode, type);
        }

        @Override
        void assertLoop(RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R> iterator, int type) {
            this.assertLoop(iterator, type);
        }

        @Override
        void assertEmpty(RelationshipSparseSelectionIterator<RelationshipSelectionTestBase.R> iterator) {
            this.assertEmpty(iterator);
        }
    }
}

