/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class DiagnosticsLoggingTest {
    DiagnosticsLoggingTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeExpectedDiagnostics() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().setInternalLogProvider((LogProvider)logProvider).impermanent().setConfig(GraphDatabaseSettings.dump_configuration, (Object)true).setConfig(GraphDatabaseSettings.pagecache_memory, (Object)"4M").build();
        try {
            logProvider.rawMessageMatcher().assertContains("Network information");
            logProvider.rawMessageMatcher().assertContains("Disk space on partition");
            logProvider.rawMessageMatcher().assertContains("Local timezone");
            logProvider.rawMessageMatcher().assertContains("Page cache: 4M");
            for (MetaDataStore.Position position : MetaDataStore.Position.values()) {
                logProvider.rawMessageMatcher().assertContains(position.name());
            }
            logProvider.rawMessageMatcher().assertContains("Transaction log");
            logProvider.rawMessageMatcher().assertContains("TimeZone version: ");
        }
        finally {
            managementService.shutdown();
        }
    }
}

