/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.kernel.DummyExtension;
import org.neo4j.kernel.DummyExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFactoryContractTest;
import org.neo4j.kernel.extension.GlobalExtensions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

class TestExtension
extends ExtensionFactoryContractTest {
    TestExtension() {
        super("dummy", DummyExtensionFactory.class);
    }

    @Test
    void shouldBeStarted() {
        GraphDatabaseAPI graphdb = this.graphDb();
        try {
            Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)((DummyExtension)((GlobalExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    void dependenciesCanBeRetrieved() {
        GraphDatabaseAPI graphdb = this.graphDb();
        try {
            GlobalExtensions globalExtensions = (GlobalExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalExtensions.class);
            Assertions.assertNotNull((Object)((DummyExtension)globalExtensions.resolveDependency(DummyExtension.class)).getDependencies().getConfig());
            Assertions.assertEquals((Object)graphdb.getDependencyResolver().resolveDependency(DatabaseManager.class), (Object)((DummyExtension)globalExtensions.resolveDependency(DummyExtension.class)).getDependencies().getDatabaseManager());
        }
        finally {
            this.managementService.shutdown();
        }
    }

    @Test
    void shouldBeShutdown() {
        GraphDatabaseAPI graphdb = this.graphDb();
        this.managementService.shutdown();
        Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)((DummyExtension)((GlobalExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
    }
}

