/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

@ImpermanentDbmsExtension
class TestTransactionEventDeadlocks {
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private GraphDatabaseService graphdb;

    TestTransactionEventDeadlocks() {
    }

    @Test
    void canAvoidDeadlockThatWouldHappenIfTheRelationshipTypeCreationTransactionModifiedData() {
        Node node;
        try (Transaction tx = this.graphdb.beginTx();){
            node = tx.createNode();
            node.setProperty("counter", (Object)0L);
            tx.commit();
        }
        tx = this.graphdb.beginTx();
        try {
            Node txNode = tx.getNodeById(node.getId());
            this.managementService.registerTransactionEventListener("neo4j", (TransactionEventListener)new RelationshipCounterTransactionEventListener(txNode));
            txNode.setProperty("state", (Object)"not broken yet");
            txNode.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"TEST"));
            txNode.removeProperty("state");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        MatcherAssert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb, (Matcher)Neo4jMatchers.hasProperty((String)"counter").withValue((Object)1L)));
    }

    private static class RelationshipCounterTransactionEventListener
    extends TransactionEventListenerAdapter<Void> {
        private final Node node;

        RelationshipCounterTransactionEventListener(Node node) {
            this.node = node;
        }

        public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            if (Iterables.count((Iterable)data.createdRelationships()) == 0L) {
                return null;
            }
            this.node.setProperty("counter", (Object)((Long)this.node.removeProperty("counter") + 1L));
            return null;
        }
    }
}

